package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  ResourceName,
  ResourceArn,
  UpdateToken
}
import scala.jdk.CollectionConverters._
final case class UpdateSubnetChangeProtectionResponse(
    updateToken: Option[UpdateToken] = None,
    firewallArn: Option[ResourceArn] = None,
    firewallName: Option[ResourceName] = None,
    subnetChangeProtection: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse = {
    import UpdateSubnetChangeProtectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        subnetChangeProtection.map(value => value: java.lang.Boolean)
      )(_.subnetChangeProtection)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly =
    zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse
      .wrap(buildAwsValue())
}
object UpdateSubnetChangeProtectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse =
      zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse(
        updateToken.map(value => value),
        firewallArn.map(value => value),
        firewallName.map(value => value),
        subnetChangeProtection.map(value => value)
      )
    def updateToken: Option[UpdateToken]
    def firewallArn: Option[ResourceArn]
    def firewallName: Option[ResourceName]
    def subnetChangeProtection: Option[Boolean]
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getSubnetChangeProtection: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("subnetChangeProtection", subnetChangeProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse
  ) extends zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly {
    override val updateToken: Option[UpdateToken] = scala
      .Option(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val subnetChangeProtection: Option[Boolean] =
      scala.Option(impl.subnetChangeProtection()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse
  ): zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly =
    new Wrapper(impl)
}
