package zio.aws.networkfirewall.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  RuleCapacity,
  Description,
  ResourceName,
  ResourceArn
}
import scala.jdk.CollectionConverters._
final case class DescribeRuleGroupMetadataResponse(
    ruleGroupArn: ResourceArn,
    ruleGroupName: ResourceName,
    description: Option[Description] = None,
    `type`: Option[zio.aws.networkfirewall.model.RuleGroupType] = None,
    capacity: Option[RuleCapacity] = None,
    statefulRuleOptions: Option[
      zio.aws.networkfirewall.model.StatefulRuleOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse = {
    import DescribeRuleGroupMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse
      .builder()
      .ruleGroupArn(ResourceArn.unwrap(ruleGroupArn): java.lang.String)
      .ruleGroupName(ResourceName.unwrap(ruleGroupName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        capacity.map(value => RuleCapacity.unwrap(value): Integer)
      )(_.capacity)
      .optionallyWith(statefulRuleOptions.map(value => value.buildAwsValue()))(
        _.statefulRuleOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly =
    zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse
      .wrap(buildAwsValue())
}
object DescribeRuleGroupMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse =
      zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse(
        ruleGroupArn,
        ruleGroupName,
        description.map(value => value),
        `type`.map(value => value),
        capacity.map(value => value),
        statefulRuleOptions.map(value => value.asEditable)
      )
    def ruleGroupArn: ResourceArn
    def ruleGroupName: ResourceName
    def description: Option[Description]
    def `type`: Option[zio.aws.networkfirewall.model.RuleGroupType]
    def capacity: Option[RuleCapacity]
    def statefulRuleOptions
        : Option[zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly]
    def getRuleGroupArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(ruleGroupArn)
    def getRuleGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(ruleGroupName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getType
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroupType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCapacity: ZIO[Any, AwsError, RuleCapacity] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getStatefulRuleOptions: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly
    ] = AwsError.unwrapOptionField("statefulRuleOptions", statefulRuleOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse
  ) extends zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly {
    override val ruleGroupArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives.ResourceArn(impl.ruleGroupArn())
    override val ruleGroupName: ResourceName =
      zio.aws.networkfirewall.model.primitives
        .ResourceName(impl.ruleGroupName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val `type`: Option[zio.aws.networkfirewall.model.RuleGroupType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.networkfirewall.model.RuleGroupType.wrap(value))
    override val capacity: Option[RuleCapacity] = scala
      .Option(impl.capacity())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.RuleCapacity(value)
      )
    override val statefulRuleOptions
        : Option[zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly] =
      scala
        .Option(impl.statefulRuleOptions())
        .map(value =>
          zio.aws.networkfirewall.model.StatefulRuleOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse
  ): zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
