package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListTlsInspectionConfigurationsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    tlsInspectionConfigurations: Optional[
      Iterable[zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse = {
    import ListTlsInspectionConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tlsInspectionConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tlsInspectionConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsResponse.ReadOnly =
    zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListTlsInspectionConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsResponse =
      zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsResponse(
        nextToken.map(value => value),
        tlsInspectionConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def tlsInspectionConfigurations: Optional[List[
      zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTlsInspectionConfigurations: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "tlsInspectionConfigurations",
      tlsInspectionConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse
  ) extends zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val tlsInspectionConfigurations: Optional[List[
      zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.tlsInspectionConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse
  ): zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
