package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{ResourceName, ResourceArn}
import scala.jdk.CollectionConverters._
final case class DeleteTlsInspectionConfigurationRequest(
    tlsInspectionConfigurationArn: Optional[ResourceArn] = Optional.Absent,
    tlsInspectionConfigurationName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest = {
    import DeleteTlsInspectionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest
      .builder()
      .optionallyWith(
        tlsInspectionConfigurationArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.tlsInspectionConfigurationArn)
      .optionallyWith(
        tlsInspectionConfigurationName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.tlsInspectionConfigurationName)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationRequest.ReadOnly =
    zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteTlsInspectionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationRequest =
      zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationRequest(
        tlsInspectionConfigurationArn.map(value => value),
        tlsInspectionConfigurationName.map(value => value)
      )
    def tlsInspectionConfigurationArn: Optional[ResourceArn]
    def tlsInspectionConfigurationName: Optional[ResourceName]
    def getTlsInspectionConfigurationArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField(
        "tlsInspectionConfigurationArn",
        tlsInspectionConfigurationArn
      )
    def getTlsInspectionConfigurationName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField(
        "tlsInspectionConfigurationName",
        tlsInspectionConfigurationName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest
  ) extends zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationRequest.ReadOnly {
    override val tlsInspectionConfigurationArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsInspectionConfigurationArn())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.ResourceArn(value)
        )
    override val tlsInspectionConfigurationName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsInspectionConfigurationName())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.ResourceName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest
  ): zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
