package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{ResourceName, ResourceArn}
import scala.jdk.CollectionConverters._
final case class DescribeTlsInspectionConfigurationRequest(
    tlsInspectionConfigurationArn: Optional[ResourceArn] = Optional.Absent,
    tlsInspectionConfigurationName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest = {
    import DescribeTlsInspectionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest
      .builder()
      .optionallyWith(
        tlsInspectionConfigurationArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.tlsInspectionConfigurationArn)
      .optionallyWith(
        tlsInspectionConfigurationName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.tlsInspectionConfigurationName)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationRequest.ReadOnly =
    zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeTlsInspectionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationRequest =
      zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationRequest(
        tlsInspectionConfigurationArn.map(value => value),
        tlsInspectionConfigurationName.map(value => value)
      )
    def tlsInspectionConfigurationArn: Optional[ResourceArn]
    def tlsInspectionConfigurationName: Optional[ResourceName]
    def getTlsInspectionConfigurationArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField(
        "tlsInspectionConfigurationArn",
        tlsInspectionConfigurationArn
      )
    def getTlsInspectionConfigurationName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField(
        "tlsInspectionConfigurationName",
        tlsInspectionConfigurationName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest
  ) extends zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationRequest.ReadOnly {
    override val tlsInspectionConfigurationArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsInspectionConfigurationArn())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.ResourceArn(value)
        )
    override val tlsInspectionConfigurationName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsInspectionConfigurationName())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.ResourceName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest
  ): zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
