package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{ResourceArn, ResourceName}
import scala.jdk.CollectionConverters._
final case class DescribeRuleGroupRequest(
    ruleGroupName: Optional[ResourceName] = Optional.Absent,
    ruleGroupArn: Optional[ResourceArn] = Optional.Absent,
    `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType] =
      Optional.Absent,
    analyzeRuleGroup: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest = {
    import DescribeRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest
      .builder()
      .optionallyWith(
        ruleGroupName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.ruleGroupName)
      .optionallyWith(
        ruleGroupArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ruleGroupArn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(analyzeRuleGroup.map(value => value: java.lang.Boolean))(
        _.analyzeRuleGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeRuleGroupRequest.ReadOnly =
    zio.aws.networkfirewall.model.DescribeRuleGroupRequest.wrap(buildAwsValue())
}
object DescribeRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.DescribeRuleGroupRequest =
      zio.aws.networkfirewall.model.DescribeRuleGroupRequest(
        ruleGroupName.map(value => value),
        ruleGroupArn.map(value => value),
        `type`.map(value => value),
        analyzeRuleGroup.map(value => value)
      )
    def ruleGroupName: Optional[ResourceName]
    def ruleGroupArn: Optional[ResourceArn]
    def `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType]
    def analyzeRuleGroup: Optional[Boolean]
    def getRuleGroupName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("ruleGroupName", ruleGroupName)
    def getRuleGroupArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ruleGroupArn", ruleGroupArn)
    def getType
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroupType] =
      AwsError.unwrapOptionField("type", `type`)
    def getAnalyzeRuleGroup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("analyzeRuleGroup", analyzeRuleGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest
  ) extends zio.aws.networkfirewall.model.DescribeRuleGroupRequest.ReadOnly {
    override val ruleGroupName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val ruleGroupArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.networkfirewall.model.RuleGroupType.wrap(value))
    override val analyzeRuleGroup: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.analyzeRuleGroup())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest
  ): zio.aws.networkfirewall.model.DescribeRuleGroupRequest.ReadOnly =
    new Wrapper(impl)
}
