package zio.aws.networkfirewall
import zio.aws.networkfirewall.model.Tag.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.networkfirewall.model.{
  DeleteFirewallRequest,
  AssociateFirewallPolicyResponse,
  UpdateFirewallPolicyRequest,
  DeleteRuleGroupRequest,
  CreateTlsInspectionConfigurationRequest,
  PutResourcePolicyResponse,
  DescribeLoggingConfigurationResponse,
  DescribeFirewallPolicyResponse,
  DescribeResourcePolicyResponse,
  UpdateTlsInspectionConfigurationResponse,
  DescribeFirewallPolicyRequest,
  DeleteRuleGroupResponse,
  UpdateFirewallPolicyResponse,
  PutResourcePolicyRequest,
  ListFirewallsRequest,
  UpdateFirewallPolicyChangeProtectionResponse,
  TLSInspectionConfigurationMetadata,
  CreateFirewallPolicyResponse,
  DescribeRuleGroupResponse,
  ListTagsForResourceRequest,
  UpdateFirewallDescriptionRequest,
  Tag,
  CreateRuleGroupResponse,
  ListRuleGroupsRequest,
  DescribeLoggingConfigurationRequest,
  DescribeFirewallResponse,
  UpdateFirewallEncryptionConfigurationResponse,
  FirewallPolicyMetadata,
  UpdateFirewallEncryptionConfigurationRequest,
  DescribeFirewallRequest,
  DeleteFirewallResponse,
  DescribeRuleGroupMetadataResponse,
  AssociateSubnetsRequest,
  ListTagsForResourceResponse,
  DeleteFirewallPolicyRequest,
  UntagResourceResponse,
  DeleteTlsInspectionConfigurationResponse,
  CreateFirewallPolicyRequest,
  FirewallMetadata,
  UpdateLoggingConfigurationRequest,
  ListTlsInspectionConfigurationsResponse,
  UpdateSubnetChangeProtectionRequest,
  CreateFirewallRequest,
  UpdateTlsInspectionConfigurationRequest,
  UpdateSubnetChangeProtectionResponse,
  DeleteTlsInspectionConfigurationRequest,
  DescribeTlsInspectionConfigurationResponse,
  UpdateRuleGroupRequest,
  UpdateFirewallDeleteProtectionRequest,
  DeleteResourcePolicyRequest,
  DescribeRuleGroupMetadataRequest,
  UntagResourceRequest,
  CreateRuleGroupRequest,
  UpdateFirewallDeleteProtectionResponse,
  CreateTlsInspectionConfigurationResponse,
  AssociateFirewallPolicyRequest,
  ListFirewallsResponse,
  DescribeRuleGroupRequest,
  ListFirewallPoliciesRequest,
  DeleteFirewallPolicyResponse,
  CreateFirewallResponse,
  DisassociateSubnetsRequest,
  DeleteResourcePolicyResponse,
  UpdateFirewallPolicyChangeProtectionRequest,
  DescribeResourcePolicyRequest,
  ListTlsInspectionConfigurationsRequest,
  AssociateSubnetsResponse,
  DescribeTlsInspectionConfigurationRequest,
  TagResourceResponse,
  DisassociateSubnetsResponse,
  RuleGroupMetadata,
  UpdateRuleGroupResponse,
  UpdateFirewallDescriptionResponse,
  ListRuleGroupsResponse,
  TagResourceRequest,
  UpdateLoggingConfigurationResponse,
  ListFirewallPoliciesResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.networkfirewall.{
  NetworkFirewallAsyncClientBuilder,
  NetworkFirewallAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait NetworkFirewall extends AspectSupport[NetworkFirewall] {
  val api: NetworkFirewallAsyncClient
  def deleteFirewallPolicy(
      request: zio.aws.networkfirewall.model.DeleteFirewallPolicyRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DeleteFirewallPolicyResponse.ReadOnly
  ]
  def describeRuleGroup(
      request: zio.aws.networkfirewall.model.DescribeRuleGroupRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DescribeRuleGroupResponse.ReadOnly
  ]
  def updateFirewallDeleteProtection(
      request: zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse.ReadOnly
  ]
  def updateFirewallDescription(
      request: zio.aws.networkfirewall.model.UpdateFirewallDescriptionRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse.ReadOnly
  ]
  def createRuleGroup(
      request: zio.aws.networkfirewall.model.CreateRuleGroupRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.CreateRuleGroupResponse.ReadOnly
  ]
  def listTLSInspectionConfigurations(
      request: zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata.ReadOnly
  ]
  def listTLSInspectionConfigurationsPaginated(
      request: zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsResponse.ReadOnly
  ]
  def listRuleGroups(
      request: zio.aws.networkfirewall.model.ListRuleGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly
  ]
  def listRuleGroupsPaginated(
      request: zio.aws.networkfirewall.model.ListRuleGroupsRequest
  ): IO[AwsError, zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly]
  def putResourcePolicy(
      request: zio.aws.networkfirewall.model.PutResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.PutResourcePolicyResponse.ReadOnly
  ]
  def updateFirewallPolicy(
      request: zio.aws.networkfirewall.model.UpdateFirewallPolicyRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse.ReadOnly
  ]
  def createTLSInspectionConfiguration(
      request: zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationResponse.ReadOnly
  ]
  def updateSubnetChangeProtection(
      request: zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly
  ]
  def describeFirewall(
      request: zio.aws.networkfirewall.model.DescribeFirewallRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly
  ]
  def updateFirewallPolicyChangeProtection(
      request: zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse.ReadOnly
  ]
  def updateFirewallEncryptionConfiguration(
      request: zio.aws.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse.ReadOnly
  ]
  def createFirewallPolicy(
      request: zio.aws.networkfirewall.model.CreateFirewallPolicyRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.CreateFirewallPolicyResponse.ReadOnly
  ]
  def describeTLSInspectionConfiguration(
      request: zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationResponse.ReadOnly
  ]
  def listFirewallPolicies(
      request: zio.aws.networkfirewall.model.ListFirewallPoliciesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly
  ]
  def listFirewallPoliciesPaginated(
      request: zio.aws.networkfirewall.model.ListFirewallPoliciesRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.ListFirewallPoliciesResponse.ReadOnly
  ]
  def updateLoggingConfiguration(
      request: zio.aws.networkfirewall.model.UpdateLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.networkfirewall.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.networkfirewall.model.UntagResourceResponse.ReadOnly]
  def describeFirewallPolicy(
      request: zio.aws.networkfirewall.model.DescribeFirewallPolicyRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse.ReadOnly
  ]
  def disassociateSubnets(
      request: zio.aws.networkfirewall.model.DisassociateSubnetsRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DisassociateSubnetsResponse.ReadOnly
  ]
  def updateTLSInspectionConfiguration(
      request: zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationResponse.ReadOnly
  ]
  def deleteResourcePolicy(
      request: zio.aws.networkfirewall.model.DeleteResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DeleteResourcePolicyResponse.ReadOnly
  ]
  def associateFirewallPolicy(
      request: zio.aws.networkfirewall.model.AssociateFirewallPolicyRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.networkfirewall.model.ListTagsForResourceRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listTagsForResourcePaginated(
      request: zio.aws.networkfirewall.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.ListTagsForResourceResponse.ReadOnly
  ]
  def associateSubnets(
      request: zio.aws.networkfirewall.model.AssociateSubnetsRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.AssociateSubnetsResponse.ReadOnly
  ]
  def listFirewalls(
      request: zio.aws.networkfirewall.model.ListFirewallsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.networkfirewall.model.FirewallMetadata.ReadOnly
  ]
  def listFirewallsPaginated(
      request: zio.aws.networkfirewall.model.ListFirewallsRequest
  ): IO[AwsError, zio.aws.networkfirewall.model.ListFirewallsResponse.ReadOnly]
  def tagResource(
      request: zio.aws.networkfirewall.model.TagResourceRequest
  ): IO[AwsError, zio.aws.networkfirewall.model.TagResourceResponse.ReadOnly]
  def deleteTLSInspectionConfiguration(
      request: zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationResponse.ReadOnly
  ]
  def describeResourcePolicy(
      request: zio.aws.networkfirewall.model.DescribeResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DescribeResourcePolicyResponse.ReadOnly
  ]
  def updateRuleGroup(
      request: zio.aws.networkfirewall.model.UpdateRuleGroupRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.UpdateRuleGroupResponse.ReadOnly
  ]
  def deleteFirewall(
      request: zio.aws.networkfirewall.model.DeleteFirewallRequest
  ): IO[AwsError, zio.aws.networkfirewall.model.DeleteFirewallResponse.ReadOnly]
  def describeRuleGroupMetadata(
      request: zio.aws.networkfirewall.model.DescribeRuleGroupMetadataRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly
  ]
  def deleteRuleGroup(
      request: zio.aws.networkfirewall.model.DeleteRuleGroupRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DeleteRuleGroupResponse.ReadOnly
  ]
  def describeLoggingConfiguration(
      request: zio.aws.networkfirewall.model.DescribeLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse.ReadOnly
  ]
  def createFirewall(
      request: zio.aws.networkfirewall.model.CreateFirewallRequest
  ): IO[AwsError, zio.aws.networkfirewall.model.CreateFirewallResponse.ReadOnly]
}
object NetworkFirewall {
  val live: ZLayer[AwsConfig, java.lang.Throwable, NetworkFirewall] =
    customized(identity)
  def customized(
      customization: NetworkFirewallAsyncClientBuilder => NetworkFirewallAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, NetworkFirewall] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: NetworkFirewallAsyncClientBuilder => NetworkFirewallAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, NetworkFirewall] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = NetworkFirewallAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[NetworkFirewallAsyncClient, NetworkFirewallAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      NetworkFirewallAsyncClient,
      NetworkFirewallAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new NetworkFirewallImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class NetworkFirewallImpl[R](
      override val api: NetworkFirewallAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends NetworkFirewall
      with AwsServiceBase[R] {
    override val serviceName: String = "NetworkFirewall"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): NetworkFirewallImpl[R1] = new NetworkFirewallImpl(api, newAspect, r)
    def deleteFirewallPolicy(
        request: zio.aws.networkfirewall.model.DeleteFirewallPolicyRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DeleteFirewallPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteFirewallPolicyRequest,
      DeleteFirewallPolicyResponse
    ]("deleteFirewallPolicy", api.deleteFirewallPolicy)(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.DeleteFirewallPolicyResponse.wrap)
      .provideEnvironment(r)
    def describeRuleGroup(
        request: zio.aws.networkfirewall.model.DescribeRuleGroupRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DescribeRuleGroupResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeRuleGroupRequest, DescribeRuleGroupResponse](
        "describeRuleGroup",
        api.describeRuleGroup
      )(request.buildAwsValue())
        .map(zio.aws.networkfirewall.model.DescribeRuleGroupResponse.wrap)
        .provideEnvironment(r)
    def updateFirewallDeleteProtection(
        request: zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateFirewallDeleteProtectionRequest,
      UpdateFirewallDeleteProtectionResponse
    ]("updateFirewallDeleteProtection", api.updateFirewallDeleteProtection)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse.wrap
    ).provideEnvironment(r)
    def updateFirewallDescription(
        request: zio.aws.networkfirewall.model.UpdateFirewallDescriptionRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateFirewallDescriptionRequest,
      UpdateFirewallDescriptionResponse
    ]("updateFirewallDescription", api.updateFirewallDescription)(
      request.buildAwsValue()
    ).map(zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse.wrap)
      .provideEnvironment(r)
    def createRuleGroup(
        request: zio.aws.networkfirewall.model.CreateRuleGroupRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.CreateRuleGroupResponse.ReadOnly
    ] = asyncRequestResponse[CreateRuleGroupRequest, CreateRuleGroupResponse](
      "createRuleGroup",
      api.createRuleGroup
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.CreateRuleGroupResponse.wrap)
      .provideEnvironment(r)
    def listTLSInspectionConfigurations(
        request: zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListTlsInspectionConfigurationsRequest,
      ListTlsInspectionConfigurationsResponse,
      TLSInspectionConfigurationMetadata
    ](
      "listTLSInspectionConfigurations",
      api.listTLSInspectionConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tlsInspectionConfigurations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata
          .wrap(item)
      )
      .provideEnvironment(r)
    def listTLSInspectionConfigurationsPaginated(
        request: zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTlsInspectionConfigurationsRequest,
      ListTlsInspectionConfigurationsResponse
    ]("listTLSInspectionConfigurations", api.listTLSInspectionConfigurations)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsResponse.wrap
    ).provideEnvironment(r)
    def listRuleGroups(
        request: zio.aws.networkfirewall.model.ListRuleGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListRuleGroupsRequest,
      ListRuleGroupsResponse,
      RuleGroupMetadata
    ](
      "listRuleGroups",
      api.listRuleGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.ruleGroups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkfirewall.model.RuleGroupMetadata.wrap(item))
      .provideEnvironment(r)
    def listRuleGroupsPaginated(
        request: zio.aws.networkfirewall.model.ListRuleGroupsRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly
    ] = asyncRequestResponse[ListRuleGroupsRequest, ListRuleGroupsResponse](
      "listRuleGroups",
      api.listRuleGroups
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.ListRuleGroupsResponse.wrap)
      .provideEnvironment(r)
    def putResourcePolicy(
        request: zio.aws.networkfirewall.model.PutResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.PutResourcePolicyResponse.ReadOnly
    ] =
      asyncRequestResponse[PutResourcePolicyRequest, PutResourcePolicyResponse](
        "putResourcePolicy",
        api.putResourcePolicy
      )(request.buildAwsValue())
        .map(zio.aws.networkfirewall.model.PutResourcePolicyResponse.wrap)
        .provideEnvironment(r)
    def updateFirewallPolicy(
        request: zio.aws.networkfirewall.model.UpdateFirewallPolicyRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateFirewallPolicyRequest,
      UpdateFirewallPolicyResponse
    ]("updateFirewallPolicy", api.updateFirewallPolicy)(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse.wrap)
      .provideEnvironment(r)
    def createTLSInspectionConfiguration(
        request: zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTlsInspectionConfigurationRequest,
      CreateTlsInspectionConfigurationResponse
    ]("createTLSInspectionConfiguration", api.createTLSInspectionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def updateSubnetChangeProtection(
        request: zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSubnetChangeProtectionRequest,
      UpdateSubnetChangeProtectionResponse
    ]("updateSubnetChangeProtection", api.updateSubnetChangeProtection)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.wrap
    ).provideEnvironment(r)
    def describeFirewall(
        request: zio.aws.networkfirewall.model.DescribeFirewallRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly
    ] = asyncRequestResponse[DescribeFirewallRequest, DescribeFirewallResponse](
      "describeFirewall",
      api.describeFirewall
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.DescribeFirewallResponse.wrap)
      .provideEnvironment(r)
    def updateFirewallPolicyChangeProtection(
        request: zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateFirewallPolicyChangeProtectionRequest,
      UpdateFirewallPolicyChangeProtectionResponse
    ](
      "updateFirewallPolicyChangeProtection",
      api.updateFirewallPolicyChangeProtection
    )(request.buildAwsValue())
      .map(
        zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse.wrap
      )
      .provideEnvironment(r)
    def updateFirewallEncryptionConfiguration(
        request: zio.aws.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateFirewallEncryptionConfigurationRequest,
      UpdateFirewallEncryptionConfigurationResponse
    ](
      "updateFirewallEncryptionConfiguration",
      api.updateFirewallEncryptionConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def createFirewallPolicy(
        request: zio.aws.networkfirewall.model.CreateFirewallPolicyRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.CreateFirewallPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateFirewallPolicyRequest,
      CreateFirewallPolicyResponse
    ]("createFirewallPolicy", api.createFirewallPolicy)(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.CreateFirewallPolicyResponse.wrap)
      .provideEnvironment(r)
    def describeTLSInspectionConfiguration(
        request: zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTlsInspectionConfigurationRequest,
      DescribeTlsInspectionConfigurationResponse
    ](
      "describeTLSInspectionConfiguration",
      api.describeTLSInspectionConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listFirewallPolicies(
        request: zio.aws.networkfirewall.model.ListFirewallPoliciesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListFirewallPoliciesRequest,
      ListFirewallPoliciesResponse,
      FirewallPolicyMetadata
    ](
      "listFirewallPolicies",
      api.listFirewallPolicies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.firewallPolicies().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.networkfirewall.model.FirewallPolicyMetadata.wrap(item)
      )
      .provideEnvironment(r)
    def listFirewallPoliciesPaginated(
        request: zio.aws.networkfirewall.model.ListFirewallPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.ListFirewallPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListFirewallPoliciesRequest,
      ListFirewallPoliciesResponse
    ]("listFirewallPolicies", api.listFirewallPolicies)(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.ListFirewallPoliciesResponse.wrap)
      .provideEnvironment(r)
    def updateLoggingConfiguration(
        request: zio.aws.networkfirewall.model.UpdateLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateLoggingConfigurationRequest,
      UpdateLoggingConfigurationResponse
    ]("updateLoggingConfiguration", api.updateLoggingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.networkfirewall.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def describeFirewallPolicy(
        request: zio.aws.networkfirewall.model.DescribeFirewallPolicyRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFirewallPolicyRequest,
      DescribeFirewallPolicyResponse
    ]("describeFirewallPolicy", api.describeFirewallPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse.wrap)
      .provideEnvironment(r)
    def disassociateSubnets(
        request: zio.aws.networkfirewall.model.DisassociateSubnetsRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DisassociateSubnetsResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateSubnetsRequest,
      DisassociateSubnetsResponse
    ]("disassociateSubnets", api.disassociateSubnets)(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.DisassociateSubnetsResponse.wrap)
      .provideEnvironment(r)
    def updateTLSInspectionConfiguration(
        request: zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateTlsInspectionConfigurationRequest,
      UpdateTlsInspectionConfigurationResponse
    ]("updateTLSInspectionConfiguration", api.updateTLSInspectionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def deleteResourcePolicy(
        request: zio.aws.networkfirewall.model.DeleteResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DeleteResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.DeleteResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def associateFirewallPolicy(
        request: zio.aws.networkfirewall.model.AssociateFirewallPolicyRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateFirewallPolicyRequest,
      AssociateFirewallPolicyResponse
    ]("associateFirewallPolicy", api.associateFirewallPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.networkfirewall.model.ListTagsForResourceRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse,
      Tag
    ](
      "listTagsForResource",
      api.listTagsForResource,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tags().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkfirewall.model.Tag.wrap(item))
      .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: zio.aws.networkfirewall.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def associateSubnets(
        request: zio.aws.networkfirewall.model.AssociateSubnetsRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.AssociateSubnetsResponse.ReadOnly
    ] = asyncRequestResponse[AssociateSubnetsRequest, AssociateSubnetsResponse](
      "associateSubnets",
      api.associateSubnets
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.AssociateSubnetsResponse.wrap)
      .provideEnvironment(r)
    def listFirewalls(
        request: zio.aws.networkfirewall.model.ListFirewallsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.FirewallMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListFirewallsRequest,
      ListFirewallsResponse,
      FirewallMetadata
    ](
      "listFirewalls",
      api.listFirewalls,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.firewalls().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkfirewall.model.FirewallMetadata.wrap(item))
      .provideEnvironment(r)
    def listFirewallsPaginated(
        request: zio.aws.networkfirewall.model.ListFirewallsRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.ListFirewallsResponse.ReadOnly
    ] = asyncRequestResponse[ListFirewallsRequest, ListFirewallsResponse](
      "listFirewalls",
      api.listFirewalls
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.ListFirewallsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.networkfirewall.model.TagResourceRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[TagResourceRequest, TagResourceResponse](
      "tagResource",
      api.tagResource
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteTLSInspectionConfiguration(
        request: zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTlsInspectionConfigurationRequest,
      DeleteTlsInspectionConfigurationResponse
    ]("deleteTLSInspectionConfiguration", api.deleteTLSInspectionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def describeResourcePolicy(
        request: zio.aws.networkfirewall.model.DescribeResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DescribeResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeResourcePolicyRequest,
      DescribeResourcePolicyResponse
    ]("describeResourcePolicy", api.describeResourcePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.networkfirewall.model.DescribeResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def updateRuleGroup(
        request: zio.aws.networkfirewall.model.UpdateRuleGroupRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.UpdateRuleGroupResponse.ReadOnly
    ] = asyncRequestResponse[UpdateRuleGroupRequest, UpdateRuleGroupResponse](
      "updateRuleGroup",
      api.updateRuleGroup
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.UpdateRuleGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteFirewall(
        request: zio.aws.networkfirewall.model.DeleteFirewallRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DeleteFirewallResponse.ReadOnly
    ] = asyncRequestResponse[DeleteFirewallRequest, DeleteFirewallResponse](
      "deleteFirewall",
      api.deleteFirewall
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.DeleteFirewallResponse.wrap)
      .provideEnvironment(r)
    def describeRuleGroupMetadata(
        request: zio.aws.networkfirewall.model.DescribeRuleGroupMetadataRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRuleGroupMetadataRequest,
      DescribeRuleGroupMetadataResponse
    ]("describeRuleGroupMetadata", api.describeRuleGroupMetadata)(
      request.buildAwsValue()
    ).map(zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.wrap)
      .provideEnvironment(r)
    def deleteRuleGroup(
        request: zio.aws.networkfirewall.model.DeleteRuleGroupRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DeleteRuleGroupResponse.ReadOnly
    ] = asyncRequestResponse[DeleteRuleGroupRequest, DeleteRuleGroupResponse](
      "deleteRuleGroup",
      api.deleteRuleGroup
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.DeleteRuleGroupResponse.wrap)
      .provideEnvironment(r)
    def describeLoggingConfiguration(
        request: zio.aws.networkfirewall.model.DescribeLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLoggingConfigurationRequest,
      DescribeLoggingConfigurationResponse
    ]("describeLoggingConfiguration", api.describeLoggingConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse.wrap
    ).provideEnvironment(r)
    def createFirewall(
        request: zio.aws.networkfirewall.model.CreateFirewallRequest
    ): IO[
      AwsError,
      zio.aws.networkfirewall.model.CreateFirewallResponse.ReadOnly
    ] = asyncRequestResponse[CreateFirewallRequest, CreateFirewallResponse](
      "createFirewall",
      api.createFirewall
    )(request.buildAwsValue())
      .map(zio.aws.networkfirewall.model.CreateFirewallResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteFirewallPolicy(
      request: zio.aws.networkfirewall.model.DeleteFirewallPolicyRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DeleteFirewallPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFirewallPolicy(request))
  def describeRuleGroup(
      request: zio.aws.networkfirewall.model.DescribeRuleGroupRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DescribeRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRuleGroup(request))
  def updateFirewallDeleteProtection(
      request: zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFirewallDeleteProtection(request))
  def updateFirewallDescription(
      request: zio.aws.networkfirewall.model.UpdateFirewallDescriptionRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFirewallDescription(request))
  def createRuleGroup(
      request: zio.aws.networkfirewall.model.CreateRuleGroupRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.CreateRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRuleGroup(request))
  def listTLSInspectionConfigurations(
      request: zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest
  ): ZStream[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.TLSInspectionConfigurationMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listTLSInspectionConfigurations(request))
  def listTLSInspectionConfigurationsPaginated(
      request: zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.ListTlsInspectionConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTLSInspectionConfigurationsPaginated(request))
  def listRuleGroups(
      request: zio.aws.networkfirewall.model.ListRuleGroupsRequest
  ): ZStream[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listRuleGroups(request))
  def listRuleGroupsPaginated(
      request: zio.aws.networkfirewall.model.ListRuleGroupsRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRuleGroupsPaginated(request))
  def putResourcePolicy(
      request: zio.aws.networkfirewall.model.PutResourcePolicyRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.PutResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePolicy(request))
  def updateFirewallPolicy(
      request: zio.aws.networkfirewall.model.UpdateFirewallPolicyRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFirewallPolicy(request))
  def createTLSInspectionConfiguration(
      request: zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTLSInspectionConfiguration(request))
  def updateSubnetChangeProtection(
      request: zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubnetChangeProtection(request))
  def describeFirewall(
      request: zio.aws.networkfirewall.model.DescribeFirewallRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFirewall(request))
  def updateFirewallPolicyChangeProtection(
      request: zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFirewallPolicyChangeProtection(request))
  def updateFirewallEncryptionConfiguration(
      request: zio.aws.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFirewallEncryptionConfiguration(request))
  def createFirewallPolicy(
      request: zio.aws.networkfirewall.model.CreateFirewallPolicyRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.CreateFirewallPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFirewallPolicy(request))
  def describeTLSInspectionConfiguration(
      request: zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DescribeTlsInspectionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTLSInspectionConfiguration(request))
  def listFirewallPolicies(
      request: zio.aws.networkfirewall.model.ListFirewallPoliciesRequest
  ): ZStream[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listFirewallPolicies(request))
  def listFirewallPoliciesPaginated(
      request: zio.aws.networkfirewall.model.ListFirewallPoliciesRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.ListFirewallPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFirewallPoliciesPaginated(request))
  def updateLoggingConfiguration(
      request: zio.aws.networkfirewall.model.UpdateLoggingConfigurationRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLoggingConfiguration(request))
  def untagResource(
      request: zio.aws.networkfirewall.model.UntagResourceRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeFirewallPolicy(
      request: zio.aws.networkfirewall.model.DescribeFirewallPolicyRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFirewallPolicy(request))
  def disassociateSubnets(
      request: zio.aws.networkfirewall.model.DisassociateSubnetsRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DisassociateSubnetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateSubnets(request))
  def updateTLSInspectionConfiguration(
      request: zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTLSInspectionConfiguration(request))
  def deleteResourcePolicy(
      request: zio.aws.networkfirewall.model.DeleteResourcePolicyRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DeleteResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def associateFirewallPolicy(
      request: zio.aws.networkfirewall.model.AssociateFirewallPolicyRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateFirewallPolicy(request))
  def listTagsForResource(
      request: zio.aws.networkfirewall.model.ListTagsForResourceRequest
  ): ZStream[zio.aws.networkfirewall.NetworkFirewall, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(
      request: zio.aws.networkfirewall.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def associateSubnets(
      request: zio.aws.networkfirewall.model.AssociateSubnetsRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.AssociateSubnetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateSubnets(request))
  def listFirewalls(
      request: zio.aws.networkfirewall.model.ListFirewallsRequest
  ): ZStream[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.FirewallMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listFirewalls(request))
  def listFirewallsPaginated(
      request: zio.aws.networkfirewall.model.ListFirewallsRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.ListFirewallsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFirewallsPaginated(request))
  def tagResource(
      request: zio.aws.networkfirewall.model.TagResourceRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteTLSInspectionConfiguration(
      request: zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DeleteTlsInspectionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTLSInspectionConfiguration(request))
  def describeResourcePolicy(
      request: zio.aws.networkfirewall.model.DescribeResourcePolicyRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DescribeResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeResourcePolicy(request))
  def updateRuleGroup(
      request: zio.aws.networkfirewall.model.UpdateRuleGroupRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.UpdateRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRuleGroup(request))
  def deleteFirewall(
      request: zio.aws.networkfirewall.model.DeleteFirewallRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DeleteFirewallResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFirewall(request))
  def describeRuleGroupMetadata(
      request: zio.aws.networkfirewall.model.DescribeRuleGroupMetadataRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRuleGroupMetadata(request))
  def deleteRuleGroup(
      request: zio.aws.networkfirewall.model.DeleteRuleGroupRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DeleteRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRuleGroup(request))
  def describeLoggingConfiguration(
      request: zio.aws.networkfirewall.model.DescribeLoggingConfigurationRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoggingConfiguration(request))
  def createFirewall(
      request: zio.aws.networkfirewall.model.CreateFirewallRequest
  ): ZIO[
    zio.aws.networkfirewall.NetworkFirewall,
    AwsError,
    zio.aws.networkfirewall.model.CreateFirewallResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFirewall(request))
}
