package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.UpdateToken
import scala.jdk.CollectionConverters._
final case class DescribeFirewallResponse(
    updateToken: Optional[UpdateToken] = Optional.Absent,
    firewall: Optional[zio.aws.networkfirewall.model.Firewall] =
      Optional.Absent,
    firewallStatus: Optional[zio.aws.networkfirewall.model.FirewallStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse = {
    import DescribeFirewallResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(firewall.map(value => value.buildAwsValue()))(_.firewall)
      .optionallyWith(firewallStatus.map(value => value.buildAwsValue()))(
        _.firewallStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly =
    zio.aws.networkfirewall.model.DescribeFirewallResponse.wrap(buildAwsValue())
}
object DescribeFirewallResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.DescribeFirewallResponse =
      zio.aws.networkfirewall.model.DescribeFirewallResponse(
        updateToken.map(value => value),
        firewall.map(value => value.asEditable),
        firewallStatus.map(value => value.asEditable)
      )
    def updateToken: Optional[UpdateToken]
    def firewall: Optional[zio.aws.networkfirewall.model.Firewall.ReadOnly]
    def firewallStatus
        : Optional[zio.aws.networkfirewall.model.FirewallStatus.ReadOnly]
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewall
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.Firewall.ReadOnly] =
      AwsError.unwrapOptionField("firewall", firewall)
    def getFirewallStatus: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.FirewallStatus.ReadOnly
    ] = AwsError.unwrapOptionField("firewallStatus", firewallStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse
  ) extends zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly {
    override val updateToken: Optional[UpdateToken] = zio.aws.core.internal
      .optionalFromNullable(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewall
        : Optional[zio.aws.networkfirewall.model.Firewall.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewall())
        .map(value => zio.aws.networkfirewall.model.Firewall.wrap(value))
    override val firewallStatus
        : Optional[zio.aws.networkfirewall.model.FirewallStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallStatus())
        .map(value => zio.aws.networkfirewall.model.FirewallStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse
  ): zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly =
    new Wrapper(impl)
}
