package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerCertificateConfiguration(
    serverCertificates: Optional[
      Iterable[zio.aws.networkfirewall.model.ServerCertificate]
    ] = Optional.Absent,
    scopes: Optional[
      Iterable[zio.aws.networkfirewall.model.ServerCertificateScope]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration = {
    import ServerCertificateConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration
      .builder()
      .optionallyWith(
        serverCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverCertificates)
      .optionallyWith(
        scopes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scopes)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ServerCertificateConfiguration.ReadOnly =
    zio.aws.networkfirewall.model.ServerCertificateConfiguration
      .wrap(buildAwsValue())
}
object ServerCertificateConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.ServerCertificateConfiguration =
      zio.aws.networkfirewall.model.ServerCertificateConfiguration(
        serverCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scopes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverCertificates: Optional[
      List[zio.aws.networkfirewall.model.ServerCertificate.ReadOnly]
    ]
    def scopes: Optional[
      List[zio.aws.networkfirewall.model.ServerCertificateScope.ReadOnly]
    ]
    def getServerCertificates: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.ServerCertificate.ReadOnly
    ]] = AwsError.unwrapOptionField("serverCertificates", serverCertificates)
    def getScopes: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.ServerCertificateScope.ReadOnly
    ]] = AwsError.unwrapOptionField("scopes", scopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration
  ) extends zio.aws.networkfirewall.model.ServerCertificateConfiguration.ReadOnly {
    override val serverCertificates: Optional[
      List[zio.aws.networkfirewall.model.ServerCertificate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverCertificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.ServerCertificate.wrap(item)
        }.toList
      )
    override val scopes: Optional[
      List[zio.aws.networkfirewall.model.ServerCertificateScope.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.ServerCertificateScope.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration
  ): zio.aws.networkfirewall.model.ServerCertificateConfiguration.ReadOnly =
    new Wrapper(impl)
}
