package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class ServerCertificate(
    resourceArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ServerCertificate = {
    import ServerCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ServerCertificate
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.ServerCertificate.ReadOnly =
    zio.aws.networkfirewall.model.ServerCertificate.wrap(buildAwsValue())
}
object ServerCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ServerCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ServerCertificate =
      zio.aws.networkfirewall.model
        .ServerCertificate(resourceArn.map(value => value))
    def resourceArn: Optional[ResourceArn]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ServerCertificate
  ) extends zio.aws.networkfirewall.model.ServerCertificate.ReadOnly {
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ServerCertificate
  ): zio.aws.networkfirewall.model.ServerCertificate.ReadOnly = new Wrapper(
    impl
  )
}
