package zio.aws.networkfirewall.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.PortRangeBound
import scala.jdk.CollectionConverters._
final case class PortRange(fromPort: PortRangeBound, toPort: PortRangeBound) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.PortRange = {
    import PortRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.PortRange
      .builder()
      .fromPort(PortRangeBound.unwrap(fromPort): Integer)
      .toPort(PortRangeBound.unwrap(toPort): Integer)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.PortRange.ReadOnly =
    zio.aws.networkfirewall.model.PortRange.wrap(buildAwsValue())
}
object PortRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.PortRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.PortRange =
      zio.aws.networkfirewall.model.PortRange(fromPort, toPort)
    def fromPort: PortRangeBound
    def toPort: PortRangeBound
    def getFromPort: ZIO[Any, Nothing, PortRangeBound] = ZIO.succeed(fromPort)
    def getToPort: ZIO[Any, Nothing, PortRangeBound] = ZIO.succeed(toPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.PortRange
  ) extends zio.aws.networkfirewall.model.PortRange.ReadOnly {
    override val fromPort: PortRangeBound =
      zio.aws.networkfirewall.model.primitives.PortRangeBound(impl.fromPort())
    override val toPort: PortRangeBound =
      zio.aws.networkfirewall.model.primitives.PortRangeBound(impl.toPort())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.PortRange
  ): zio.aws.networkfirewall.model.PortRange.ReadOnly = new Wrapper(impl)
}
