package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.{Destination, Port, Source}
import scala.jdk.CollectionConverters._
final case class Header(
    protocol: zio.aws.networkfirewall.model.StatefulRuleProtocol,
    source: Source,
    sourcePort: Port,
    direction: zio.aws.networkfirewall.model.StatefulRuleDirection,
    destination: Destination,
    destinationPort: Port
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.Header = {
    import Header.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.Header
      .builder()
      .protocol(protocol.unwrap)
      .source(Source.unwrap(source): java.lang.String)
      .sourcePort(Port.unwrap(sourcePort): java.lang.String)
      .direction(direction.unwrap)
      .destination(Destination.unwrap(destination): java.lang.String)
      .destinationPort(Port.unwrap(destinationPort): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.Header.ReadOnly =
    zio.aws.networkfirewall.model.Header.wrap(buildAwsValue())
}
object Header {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.Header
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.Header =
      zio.aws.networkfirewall.model.Header(
        protocol,
        source,
        sourcePort,
        direction,
        destination,
        destinationPort
      )
    def protocol: zio.aws.networkfirewall.model.StatefulRuleProtocol
    def source: Source
    def sourcePort: Port
    def direction: zio.aws.networkfirewall.model.StatefulRuleDirection
    def destination: Destination
    def destinationPort: Port
    def getProtocol: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.StatefulRuleProtocol
    ] = ZIO.succeed(protocol)
    def getSource: ZIO[Any, Nothing, Source] = ZIO.succeed(source)
    def getSourcePort: ZIO[Any, Nothing, Port] = ZIO.succeed(sourcePort)
    def getDirection: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.StatefulRuleDirection
    ] = ZIO.succeed(direction)
    def getDestination: ZIO[Any, Nothing, Destination] =
      ZIO.succeed(destination)
    def getDestinationPort: ZIO[Any, Nothing, Port] =
      ZIO.succeed(destinationPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.Header
  ) extends zio.aws.networkfirewall.model.Header.ReadOnly {
    override val protocol: zio.aws.networkfirewall.model.StatefulRuleProtocol =
      zio.aws.networkfirewall.model.StatefulRuleProtocol.wrap(impl.protocol())
    override val source: Source =
      zio.aws.networkfirewall.model.primitives.Source(impl.source())
    override val sourcePort: Port =
      zio.aws.networkfirewall.model.primitives.Port(impl.sourcePort())
    override val direction
        : zio.aws.networkfirewall.model.StatefulRuleDirection =
      zio.aws.networkfirewall.model.StatefulRuleDirection.wrap(impl.direction())
    override val destination: Destination =
      zio.aws.networkfirewall.model.primitives.Destination(impl.destination())
    override val destinationPort: Port =
      zio.aws.networkfirewall.model.primitives.Port(impl.destinationPort())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.Header
  ): zio.aws.networkfirewall.model.Header.ReadOnly = new Wrapper(impl)
}
