package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  UpdateToken,
  ResourceName,
  ResourceArn
}
import scala.jdk.CollectionConverters._
final case class DisassociateSubnetsResponse(
    firewallArn: Optional[ResourceArn] = Optional.Absent,
    firewallName: Optional[ResourceName] = Optional.Absent,
    subnetMappings: Optional[
      Iterable[zio.aws.networkfirewall.model.SubnetMapping]
    ] = Optional.Absent,
    updateToken: Optional[UpdateToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse = {
    import DisassociateSubnetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse
      .builder()
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        subnetMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetMappings)
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DisassociateSubnetsResponse.ReadOnly =
    zio.aws.networkfirewall.model.DisassociateSubnetsResponse
      .wrap(buildAwsValue())
}
object DisassociateSubnetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.DisassociateSubnetsResponse =
      zio.aws.networkfirewall.model.DisassociateSubnetsResponse(
        firewallArn.map(value => value),
        firewallName.map(value => value),
        subnetMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updateToken.map(value => value)
      )
    def firewallArn: Optional[ResourceArn]
    def firewallName: Optional[ResourceName]
    def subnetMappings
        : Optional[List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly]]
    def updateToken: Optional[UpdateToken]
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getSubnetMappings: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.SubnetMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("subnetMappings", subnetMappings)
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse
  ) extends zio.aws.networkfirewall.model.DisassociateSubnetsResponse.ReadOnly {
    override val firewallArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val subnetMappings
        : Optional[List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.SubnetMapping.wrap(item)
          }.toList
        )
    override val updateToken: Optional[UpdateToken] = zio.aws.core.internal
      .optionalFromNullable(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse
  ): zio.aws.networkfirewall.model.DisassociateSubnetsResponse.ReadOnly =
    new Wrapper(impl)
}
