package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters._
sealed trait IPAddressType {
  def unwrap
      : software.amazon.awssdk.services.networkfirewall.model.IPAddressType
}
object IPAddressType {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.IPAddressType
  ): zio.aws.networkfirewall.model.IPAddressType = value match {
    case software.amazon.awssdk.services.networkfirewall.model.IPAddressType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.IPAddressType.DUALSTACK =>
      val r = DUALSTACK
      r
    case software.amazon.awssdk.services.networkfirewall.model.IPAddressType.IPV4 =>
      val r = IPV4
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.IPAddressType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.IPAddressType =
      software.amazon.awssdk.services.networkfirewall.model.IPAddressType.UNKNOWN_TO_SDK_VERSION
  }
  case object DUALSTACK extends zio.aws.networkfirewall.model.IPAddressType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.IPAddressType =
      software.amazon.awssdk.services.networkfirewall.model.IPAddressType.DUALSTACK
  }
  case object IPV4 extends zio.aws.networkfirewall.model.IPAddressType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.IPAddressType =
      software.amazon.awssdk.services.networkfirewall.model.IPAddressType.IPV4
  }
}
