package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.{
  RuleCapacity,
  Description,
  ResourceArn,
  NumberOfAssociations,
  LastUpdateTime,
  ResourceId,
  ResourceName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FirewallPolicyResponse(
    firewallPolicyName: ResourceName,
    firewallPolicyArn: ResourceArn,
    firewallPolicyId: ResourceId,
    description: Optional[Description] = Optional.Absent,
    firewallPolicyStatus: Optional[
      zio.aws.networkfirewall.model.ResourceStatus
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkfirewall.model.Tag]] =
      Optional.Absent,
    consumedStatelessRuleCapacity: Optional[RuleCapacity] = Optional.Absent,
    consumedStatefulRuleCapacity: Optional[RuleCapacity] = Optional.Absent,
    numberOfAssociations: Optional[NumberOfAssociations] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration
    ] = Optional.Absent,
    lastModifiedTime: Optional[LastUpdateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyResponse = {
    import FirewallPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyResponse
      .builder()
      .firewallPolicyName(
        ResourceName.unwrap(firewallPolicyName): java.lang.String
      )
      .firewallPolicyArn(
        ResourceArn.unwrap(firewallPolicyArn): java.lang.String
      )
      .firewallPolicyId(ResourceId.unwrap(firewallPolicyId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(firewallPolicyStatus.map(value => value.unwrap))(
        _.firewallPolicyStatus
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        consumedStatelessRuleCapacity.map(value =>
          RuleCapacity.unwrap(value): Integer
        )
      )(_.consumedStatelessRuleCapacity)
      .optionallyWith(
        consumedStatefulRuleCapacity.map(value =>
          RuleCapacity.unwrap(value): Integer
        )
      )(_.consumedStatefulRuleCapacity)
      .optionallyWith(
        numberOfAssociations.map(value =>
          NumberOfAssociations.unwrap(value): Integer
        )
      )(_.numberOfAssociations)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        lastModifiedTime.map(value => LastUpdateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly =
    zio.aws.networkfirewall.model.FirewallPolicyResponse.wrap(buildAwsValue())
}
object FirewallPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.FirewallPolicyResponse =
      zio.aws.networkfirewall.model.FirewallPolicyResponse(
        firewallPolicyName,
        firewallPolicyArn,
        firewallPolicyId,
        description.map(value => value),
        firewallPolicyStatus.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consumedStatelessRuleCapacity.map(value => value),
        consumedStatefulRuleCapacity.map(value => value),
        numberOfAssociations.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        lastModifiedTime.map(value => value)
      )
    def firewallPolicyName: ResourceName
    def firewallPolicyArn: ResourceArn
    def firewallPolicyId: ResourceId
    def description: Optional[Description]
    def firewallPolicyStatus
        : Optional[zio.aws.networkfirewall.model.ResourceStatus]
    def tags: Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def consumedStatelessRuleCapacity: Optional[RuleCapacity]
    def consumedStatefulRuleCapacity: Optional[RuleCapacity]
    def numberOfAssociations: Optional[NumberOfAssociations]
    def encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ]
    def lastModifiedTime: Optional[LastUpdateTime]
    def getFirewallPolicyName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(firewallPolicyName)
    def getFirewallPolicyArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(firewallPolicyArn)
    def getFirewallPolicyId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallPolicyId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFirewallPolicyStatus
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.ResourceStatus] =
      AwsError.unwrapOptionField("firewallPolicyStatus", firewallPolicyStatus)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConsumedStatelessRuleCapacity: ZIO[Any, AwsError, RuleCapacity] =
      AwsError.unwrapOptionField(
        "consumedStatelessRuleCapacity",
        consumedStatelessRuleCapacity
      )
    def getConsumedStatefulRuleCapacity: ZIO[Any, AwsError, RuleCapacity] =
      AwsError.unwrapOptionField(
        "consumedStatefulRuleCapacity",
        consumedStatefulRuleCapacity
      )
    def getNumberOfAssociations: ZIO[Any, AwsError, NumberOfAssociations] =
      AwsError.unwrapOptionField("numberOfAssociations", numberOfAssociations)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getLastModifiedTime: ZIO[Any, AwsError, LastUpdateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyResponse
  ) extends zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly {
    override val firewallPolicyName: ResourceName =
      zio.aws.networkfirewall.model.primitives
        .ResourceName(impl.firewallPolicyName())
    override val firewallPolicyArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives
        .ResourceArn(impl.firewallPolicyArn())
    override val firewallPolicyId: ResourceId =
      zio.aws.networkfirewall.model.primitives
        .ResourceId(impl.firewallPolicyId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val firewallPolicyStatus
        : Optional[zio.aws.networkfirewall.model.ResourceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyStatus())
        .map(value => zio.aws.networkfirewall.model.ResourceStatus.wrap(value))
    override val tags
        : Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Tag.wrap(item)
          }.toList
        )
    override val consumedStatelessRuleCapacity: Optional[RuleCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedStatelessRuleCapacity())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.RuleCapacity(value)
        )
    override val consumedStatefulRuleCapacity: Optional[RuleCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedStatefulRuleCapacity())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.RuleCapacity(value)
        )
    override val numberOfAssociations: Optional[NumberOfAssociations] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfAssociations())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.NumberOfAssociations(value)
        )
    override val encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.networkfirewall.model.EncryptionConfiguration.wrap(value)
      )
    override val lastModifiedTime: Optional[LastUpdateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.LastUpdateTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyResponse
  ): zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
