package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  ResourceName,
  ResourceArn,
  UpdateToken
}
import scala.jdk.CollectionConverters._
final case class AssociateFirewallPolicyRequest(
    updateToken: Optional[UpdateToken] = Optional.Absent,
    firewallArn: Optional[ResourceArn] = Optional.Absent,
    firewallName: Optional[ResourceName] = Optional.Absent,
    firewallPolicyArn: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest = {
    import AssociateFirewallPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .firewallPolicyArn(
        ResourceArn.unwrap(firewallPolicyArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.AssociateFirewallPolicyRequest.ReadOnly =
    zio.aws.networkfirewall.model.AssociateFirewallPolicyRequest
      .wrap(buildAwsValue())
}
object AssociateFirewallPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.AssociateFirewallPolicyRequest =
      zio.aws.networkfirewall.model.AssociateFirewallPolicyRequest(
        updateToken.map(value => value),
        firewallArn.map(value => value),
        firewallName.map(value => value),
        firewallPolicyArn
      )
    def updateToken: Optional[UpdateToken]
    def firewallArn: Optional[ResourceArn]
    def firewallName: Optional[ResourceName]
    def firewallPolicyArn: ResourceArn
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getFirewallPolicyArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(firewallPolicyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest
  ) extends zio.aws.networkfirewall.model.AssociateFirewallPolicyRequest.ReadOnly {
    override val updateToken: Optional[UpdateToken] = zio.aws.core.internal
      .optionalFromNullable(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewallArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallPolicyArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives
        .ResourceArn(impl.firewallPolicyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest
  ): zio.aws.networkfirewall.model.AssociateFirewallPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
