package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.PolicyString
import scala.jdk.CollectionConverters._
final case class DescribeResourcePolicyResponse(
    policy: Optional[PolicyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse = {
    import DescribeResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => PolicyString.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeResourcePolicyResponse.ReadOnly =
    zio.aws.networkfirewall.model.DescribeResourcePolicyResponse
      .wrap(buildAwsValue())
}
object DescribeResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeResourcePolicyResponse =
      zio.aws.networkfirewall.model
        .DescribeResourcePolicyResponse(policy.map(value => value))
    def policy: Optional[PolicyString]
    def getPolicy: ZIO[Any, AwsError, PolicyString] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse
  ) extends zio.aws.networkfirewall.model.DescribeResourcePolicyResponse.ReadOnly {
    override val policy: Optional[PolicyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PolicyString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse
  ): zio.aws.networkfirewall.model.DescribeResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
