package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionType {
  def unwrap
      : software.amazon.awssdk.services.networkfirewall.model.EncryptionType
}
object EncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.EncryptionType
  ): zio.aws.networkfirewall.model.EncryptionType = value match {
    case software.amazon.awssdk.services.networkfirewall.model.EncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.EncryptionType.CUSTOMER_KMS =>
      val r = CUSTOMER_KMS
      r
    case software.amazon.awssdk.services.networkfirewall.model.EncryptionType.AWS_OWNED_KMS_KEY =>
      val r = AWS_OWNED_KMS_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.EncryptionType =
      software.amazon.awssdk.services.networkfirewall.model.EncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOMER_KMS
      extends zio.aws.networkfirewall.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.EncryptionType =
      software.amazon.awssdk.services.networkfirewall.model.EncryptionType.CUSTOMER_KMS
  }
  case object AWS_OWNED_KMS_KEY
      extends zio.aws.networkfirewall.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.EncryptionType =
      software.amazon.awssdk.services.networkfirewall.model.EncryptionType.AWS_OWNED_KMS_KEY
  }
}
