package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{UpdateToken, ResourceArn}
import scala.jdk.CollectionConverters._
final case class SourceMetadata(
    sourceArn: Optional[ResourceArn] = Optional.Absent,
    sourceUpdateToken: Optional[UpdateToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.SourceMetadata = {
    import SourceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.SourceMetadata
      .builder()
      .optionallyWith(
        sourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.sourceArn)
      .optionallyWith(
        sourceUpdateToken.map(value =>
          UpdateToken.unwrap(value): java.lang.String
        )
      )(_.sourceUpdateToken)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.SourceMetadata.ReadOnly =
    zio.aws.networkfirewall.model.SourceMetadata.wrap(buildAwsValue())
}
object SourceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.SourceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.SourceMetadata =
      zio.aws.networkfirewall.model.SourceMetadata(
        sourceArn.map(value => value),
        sourceUpdateToken.map(value => value)
      )
    def sourceArn: Optional[ResourceArn]
    def sourceUpdateToken: Optional[UpdateToken]
    def getSourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getSourceUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("sourceUpdateToken", sourceUpdateToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.SourceMetadata
  ) extends zio.aws.networkfirewall.model.SourceMetadata.ReadOnly {
    override val sourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val sourceUpdateToken: Optional[UpdateToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceUpdateToken())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.UpdateToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.SourceMetadata
  ): zio.aws.networkfirewall.model.SourceMetadata.ReadOnly = new Wrapper(impl)
}
