package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  UpdateToken,
  ResourceName,
  ResourceArn
}
import scala.jdk.CollectionConverters._
final case class UpdateFirewallDeleteProtectionResponse(
    firewallArn: Optional[ResourceArn] = Optional.Absent,
    firewallName: Optional[ResourceName] = Optional.Absent,
    deleteProtection: Optional[Boolean] = Optional.Absent,
    updateToken: Optional[UpdateToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse = {
    import UpdateFirewallDeleteProtectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse
      .builder()
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(deleteProtection.map(value => value: java.lang.Boolean))(
        _.deleteProtection
      )
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse.ReadOnly =
    zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse
      .wrap(buildAwsValue())
}
object UpdateFirewallDeleteProtectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse =
      zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse(
        firewallArn.map(value => value),
        firewallName.map(value => value),
        deleteProtection.map(value => value),
        updateToken.map(value => value)
      )
    def firewallArn: Optional[ResourceArn]
    def firewallName: Optional[ResourceName]
    def deleteProtection: Optional[Boolean]
    def updateToken: Optional[UpdateToken]
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getDeleteProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteProtection", deleteProtection)
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse
  ) extends zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse.ReadOnly {
    override val firewallArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val deleteProtection: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteProtection())
      .map(value => value: Boolean)
    override val updateToken: Optional[UpdateToken] = zio.aws.core.internal
      .optionalFromNullable(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse
  ): zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse.ReadOnly =
    new Wrapper(impl)
}
