package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StatefulEngineOptions(
    ruleOrder: Optional[zio.aws.networkfirewall.model.RuleOrder] =
      Optional.Absent,
    streamExceptionPolicy: Optional[
      zio.aws.networkfirewall.model.StreamExceptionPolicy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions = {
    import StatefulEngineOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions
      .builder()
      .optionallyWith(ruleOrder.map(value => value.unwrap))(_.ruleOrder)
      .optionallyWith(streamExceptionPolicy.map(value => value.unwrap))(
        _.streamExceptionPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly =
    zio.aws.networkfirewall.model.StatefulEngineOptions.wrap(buildAwsValue())
}
object StatefulEngineOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.StatefulEngineOptions =
      zio.aws.networkfirewall.model.StatefulEngineOptions(
        ruleOrder.map(value => value),
        streamExceptionPolicy.map(value => value)
      )
    def ruleOrder: Optional[zio.aws.networkfirewall.model.RuleOrder]
    def streamExceptionPolicy
        : Optional[zio.aws.networkfirewall.model.StreamExceptionPolicy]
    def getRuleOrder
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleOrder] =
      AwsError.unwrapOptionField("ruleOrder", ruleOrder)
    def getStreamExceptionPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.StreamExceptionPolicy
    ] =
      AwsError.unwrapOptionField("streamExceptionPolicy", streamExceptionPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions
  ) extends zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly {
    override val ruleOrder: Optional[zio.aws.networkfirewall.model.RuleOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleOrder())
        .map(value => zio.aws.networkfirewall.model.RuleOrder.wrap(value))
    override val streamExceptionPolicy
        : Optional[zio.aws.networkfirewall.model.StreamExceptionPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamExceptionPolicy())
        .map(value =>
          zio.aws.networkfirewall.model.StreamExceptionPolicy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions
  ): zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly = new Wrapper(
    impl
  )
}
