package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.UpdateToken
import scala.jdk.CollectionConverters._
final case class PerObjectStatus(
    syncStatus: Optional[zio.aws.networkfirewall.model.PerObjectSyncStatus] =
      Optional.Absent,
    updateToken: Optional[UpdateToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.PerObjectStatus = {
    import PerObjectStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.PerObjectStatus
      .builder()
      .optionallyWith(syncStatus.map(value => value.unwrap))(_.syncStatus)
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.PerObjectStatus.ReadOnly =
    zio.aws.networkfirewall.model.PerObjectStatus.wrap(buildAwsValue())
}
object PerObjectStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.PerObjectStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.PerObjectStatus =
      zio.aws.networkfirewall.model.PerObjectStatus(
        syncStatus.map(value => value),
        updateToken.map(value => value)
      )
    def syncStatus: Optional[zio.aws.networkfirewall.model.PerObjectSyncStatus]
    def updateToken: Optional[UpdateToken]
    def getSyncStatus: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.PerObjectSyncStatus
    ] = AwsError.unwrapOptionField("syncStatus", syncStatus)
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.PerObjectStatus
  ) extends zio.aws.networkfirewall.model.PerObjectStatus.ReadOnly {
    override val syncStatus
        : Optional[zio.aws.networkfirewall.model.PerObjectSyncStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncStatus())
        .map(value =>
          zio.aws.networkfirewall.model.PerObjectSyncStatus.wrap(value)
        )
    override val updateToken: Optional[UpdateToken] = zio.aws.core.internal
      .optionalFromNullable(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.PerObjectStatus
  ): zio.aws.networkfirewall.model.PerObjectStatus.ReadOnly = new Wrapper(impl)
}
