package zio.aws.networkfirewall
import zio.aws.networkfirewall.model.Tag.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.networkfirewall.model.{
  DeleteFirewallRequest,
  UpdateFirewallPolicyRequest,
  DeleteRuleGroupRequest,
  DescribeFirewallPolicyRequest,
  PutResourcePolicyRequest,
  ListFirewallsRequest,
  ListTagsForResourceRequest,
  UpdateFirewallDescriptionRequest,
  ListRuleGroupsRequest,
  DescribeLoggingConfigurationRequest,
  UpdateFirewallEncryptionConfigurationRequest,
  DescribeFirewallRequest,
  AssociateSubnetsRequest,
  DeleteFirewallPolicyRequest,
  CreateFirewallPolicyRequest,
  UpdateLoggingConfigurationRequest,
  UpdateSubnetChangeProtectionRequest,
  CreateFirewallRequest,
  UpdateRuleGroupRequest,
  UpdateFirewallDeleteProtectionRequest,
  DeleteResourcePolicyRequest,
  DescribeRuleGroupMetadataRequest,
  UntagResourceRequest,
  CreateRuleGroupRequest,
  AssociateFirewallPolicyRequest,
  DescribeRuleGroupRequest,
  ListFirewallPoliciesRequest,
  DisassociateSubnetsRequest,
  UpdateFirewallPolicyChangeProtectionRequest,
  DescribeResourcePolicyRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient
import zio.stream.ZStream
object NetworkFirewallMock extends Mock[NetworkFirewall] {
  object DeleteFirewallPolicy
      extends Effect[
        DeleteFirewallPolicyRequest,
        AwsError,
        zio.aws.networkfirewall.model.DeleteFirewallPolicyResponse.ReadOnly
      ]
  object DescribeRuleGroup
      extends Effect[
        DescribeRuleGroupRequest,
        AwsError,
        zio.aws.networkfirewall.model.DescribeRuleGroupResponse.ReadOnly
      ]
  object UpdateFirewallDeleteProtection
      extends Effect[
        UpdateFirewallDeleteProtectionRequest,
        AwsError,
        zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse.ReadOnly
      ]
  object UpdateFirewallDescription
      extends Effect[
        UpdateFirewallDescriptionRequest,
        AwsError,
        zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse.ReadOnly
      ]
  object CreateRuleGroup
      extends Effect[
        CreateRuleGroupRequest,
        AwsError,
        zio.aws.networkfirewall.model.CreateRuleGroupResponse.ReadOnly
      ]
  object ListRuleGroups
      extends Stream[
        ListRuleGroupsRequest,
        AwsError,
        zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly
      ]
  object ListRuleGroupsPaginated
      extends Effect[
        ListRuleGroupsRequest,
        AwsError,
        zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.networkfirewall.model.PutResourcePolicyResponse.ReadOnly
      ]
  object UpdateFirewallPolicy
      extends Effect[
        UpdateFirewallPolicyRequest,
        AwsError,
        zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse.ReadOnly
      ]
  object UpdateSubnetChangeProtection
      extends Effect[
        UpdateSubnetChangeProtectionRequest,
        AwsError,
        zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly
      ]
  object DescribeFirewall
      extends Effect[
        DescribeFirewallRequest,
        AwsError,
        zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly
      ]
  object UpdateFirewallPolicyChangeProtection
      extends Effect[
        UpdateFirewallPolicyChangeProtectionRequest,
        AwsError,
        zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse.ReadOnly
      ]
  object UpdateFirewallEncryptionConfiguration
      extends Effect[
        UpdateFirewallEncryptionConfigurationRequest,
        AwsError,
        zio.aws.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse.ReadOnly
      ]
  object CreateFirewallPolicy
      extends Effect[
        CreateFirewallPolicyRequest,
        AwsError,
        zio.aws.networkfirewall.model.CreateFirewallPolicyResponse.ReadOnly
      ]
  object ListFirewallPolicies
      extends Stream[
        ListFirewallPoliciesRequest,
        AwsError,
        zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly
      ]
  object ListFirewallPoliciesPaginated
      extends Effect[
        ListFirewallPoliciesRequest,
        AwsError,
        zio.aws.networkfirewall.model.ListFirewallPoliciesResponse.ReadOnly
      ]
  object UpdateLoggingConfiguration
      extends Effect[
        UpdateLoggingConfigurationRequest,
        AwsError,
        zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.networkfirewall.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeFirewallPolicy
      extends Effect[
        DescribeFirewallPolicyRequest,
        AwsError,
        zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse.ReadOnly
      ]
  object DisassociateSubnets
      extends Effect[
        DisassociateSubnetsRequest,
        AwsError,
        zio.aws.networkfirewall.model.DisassociateSubnetsResponse.ReadOnly
      ]
  object DeleteResourcePolicy
      extends Effect[
        DeleteResourcePolicyRequest,
        AwsError,
        zio.aws.networkfirewall.model.DeleteResourcePolicyResponse.ReadOnly
      ]
  object AssociateFirewallPolicy
      extends Effect[
        AssociateFirewallPolicyRequest,
        AwsError,
        zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[ListTagsForResourceRequest, AwsError, ReadOnly]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.networkfirewall.model.ListTagsForResourceResponse.ReadOnly
      ]
  object AssociateSubnets
      extends Effect[
        AssociateSubnetsRequest,
        AwsError,
        zio.aws.networkfirewall.model.AssociateSubnetsResponse.ReadOnly
      ]
  object ListFirewalls
      extends Stream[
        ListFirewallsRequest,
        AwsError,
        zio.aws.networkfirewall.model.FirewallMetadata.ReadOnly
      ]
  object ListFirewallsPaginated
      extends Effect[
        ListFirewallsRequest,
        AwsError,
        zio.aws.networkfirewall.model.ListFirewallsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.networkfirewall.model.TagResourceResponse.ReadOnly
      ]
  object DescribeResourcePolicy
      extends Effect[
        DescribeResourcePolicyRequest,
        AwsError,
        zio.aws.networkfirewall.model.DescribeResourcePolicyResponse.ReadOnly
      ]
  object UpdateRuleGroup
      extends Effect[
        UpdateRuleGroupRequest,
        AwsError,
        zio.aws.networkfirewall.model.UpdateRuleGroupResponse.ReadOnly
      ]
  object DeleteFirewall
      extends Effect[
        DeleteFirewallRequest,
        AwsError,
        zio.aws.networkfirewall.model.DeleteFirewallResponse.ReadOnly
      ]
  object DescribeRuleGroupMetadata
      extends Effect[
        DescribeRuleGroupMetadataRequest,
        AwsError,
        zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly
      ]
  object DeleteRuleGroup
      extends Effect[
        DeleteRuleGroupRequest,
        AwsError,
        zio.aws.networkfirewall.model.DeleteRuleGroupResponse.ReadOnly
      ]
  object DescribeLoggingConfiguration
      extends Effect[
        DescribeLoggingConfigurationRequest,
        AwsError,
        zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse.ReadOnly
      ]
  object CreateFirewall
      extends Effect[
        CreateFirewallRequest,
        AwsError,
        zio.aws.networkfirewall.model.CreateFirewallResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, NetworkFirewall] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, NetworkFirewall] { rts =>
        zio.ZIO.succeed {
          new NetworkFirewall {
            val api: NetworkFirewallAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): NetworkFirewall = this
            def deleteFirewallPolicy(request: DeleteFirewallPolicyRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.DeleteFirewallPolicyResponse.ReadOnly
            ] = proxy(DeleteFirewallPolicy, request)
            def describeRuleGroup(request: DescribeRuleGroupRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.DescribeRuleGroupResponse.ReadOnly
            ] = proxy(DescribeRuleGroup, request)
            def updateFirewallDeleteProtection(
                request: UpdateFirewallDeleteProtectionRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionResponse.ReadOnly
            ] = proxy(UpdateFirewallDeleteProtection, request)
            def updateFirewallDescription(
                request: UpdateFirewallDescriptionRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse.ReadOnly
            ] = proxy(UpdateFirewallDescription, request)
            def createRuleGroup(request: CreateRuleGroupRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.CreateRuleGroupResponse.ReadOnly
            ] = proxy(CreateRuleGroup, request)
            def listRuleGroups(request: ListRuleGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRuleGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRuleGroupsPaginated(request: ListRuleGroupsRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly
            ] = proxy(ListRuleGroupsPaginated, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def updateFirewallPolicy(request: UpdateFirewallPolicyRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.UpdateFirewallPolicyResponse.ReadOnly
            ] = proxy(UpdateFirewallPolicy, request)
            def updateSubnetChangeProtection(
                request: UpdateSubnetChangeProtectionRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly
            ] = proxy(UpdateSubnetChangeProtection, request)
            def describeFirewall(request: DescribeFirewallRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly
            ] = proxy(DescribeFirewall, request)
            def updateFirewallPolicyChangeProtection(
                request: UpdateFirewallPolicyChangeProtectionRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse.ReadOnly
            ] = proxy(UpdateFirewallPolicyChangeProtection, request)
            def updateFirewallEncryptionConfiguration(
                request: UpdateFirewallEncryptionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse.ReadOnly
            ] = proxy(UpdateFirewallEncryptionConfiguration, request)
            def createFirewallPolicy(request: CreateFirewallPolicyRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.CreateFirewallPolicyResponse.ReadOnly
            ] = proxy(CreateFirewallPolicy, request)
            def listFirewallPolicies(
                request: ListFirewallPoliciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFirewallPolicies, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFirewallPoliciesPaginated(
                request: ListFirewallPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.ListFirewallPoliciesResponse.ReadOnly
            ] = proxy(ListFirewallPoliciesPaginated, request)
            def updateLoggingConfiguration(
                request: UpdateLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse.ReadOnly
            ] = proxy(UpdateLoggingConfiguration, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def describeFirewallPolicy(
                request: DescribeFirewallPolicyRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse.ReadOnly
            ] = proxy(DescribeFirewallPolicy, request)
            def disassociateSubnets(request: DisassociateSubnetsRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.DisassociateSubnetsResponse.ReadOnly
            ] = proxy(DisassociateSubnets, request)
            def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.DeleteResourcePolicyResponse.ReadOnly
            ] = proxy(DeleteResourcePolicy, request)
            def associateFirewallPolicy(
                request: AssociateFirewallPolicyRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly
            ] = proxy(AssociateFirewallPolicy, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTagsForResource, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def associateSubnets(request: AssociateSubnetsRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.AssociateSubnetsResponse.ReadOnly
            ] = proxy(AssociateSubnets, request)
            def listFirewalls(request: ListFirewallsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.networkfirewall.model.FirewallMetadata.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFirewalls, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFirewallsPaginated(request: ListFirewallsRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.ListFirewallsResponse.ReadOnly
            ] = proxy(ListFirewallsPaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def describeResourcePolicy(
                request: DescribeResourcePolicyRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.DescribeResourcePolicyResponse.ReadOnly
            ] = proxy(DescribeResourcePolicy, request)
            def updateRuleGroup(request: UpdateRuleGroupRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.UpdateRuleGroupResponse.ReadOnly
            ] = proxy(UpdateRuleGroup, request)
            def deleteFirewall(request: DeleteFirewallRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.DeleteFirewallResponse.ReadOnly
            ] = proxy(DeleteFirewall, request)
            def describeRuleGroupMetadata(
                request: DescribeRuleGroupMetadataRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.DescribeRuleGroupMetadataResponse.ReadOnly
            ] = proxy(DescribeRuleGroupMetadata, request)
            def deleteRuleGroup(request: DeleteRuleGroupRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.DeleteRuleGroupResponse.ReadOnly
            ] = proxy(DeleteRuleGroup, request)
            def describeLoggingConfiguration(
                request: DescribeLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse.ReadOnly
            ] = proxy(DescribeLoggingConfiguration, request)
            def createFirewall(request: CreateFirewallRequest): IO[
              AwsError,
              zio.aws.networkfirewall.model.CreateFirewallResponse.ReadOnly
            ] = proxy(CreateFirewall, request)
          }
        }
      }
    }
  }
}
