package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CapacityUsageSummary(
    cidRs: Optional[zio.aws.networkfirewall.model.CIDRSummary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.CapacityUsageSummary = {
    import CapacityUsageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.CapacityUsageSummary
      .builder()
      .optionallyWith(cidRs.map(value => value.buildAwsValue()))(_.cidRs)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.CapacityUsageSummary.ReadOnly =
    zio.aws.networkfirewall.model.CapacityUsageSummary.wrap(buildAwsValue())
}
object CapacityUsageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.CapacityUsageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.CapacityUsageSummary =
      zio.aws.networkfirewall.model
        .CapacityUsageSummary(cidRs.map(value => value.asEditable))
    def cidRs: Optional[zio.aws.networkfirewall.model.CIDRSummary.ReadOnly]
    def getCidRs: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.CIDRSummary.ReadOnly
    ] = AwsError.unwrapOptionField("cidRs", cidRs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.CapacityUsageSummary
  ) extends zio.aws.networkfirewall.model.CapacityUsageSummary.ReadOnly {
    override val cidRs
        : Optional[zio.aws.networkfirewall.model.CIDRSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidRs())
        .map(value => zio.aws.networkfirewall.model.CIDRSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.CapacityUsageSummary
  ): zio.aws.networkfirewall.model.CapacityUsageSummary.ReadOnly = new Wrapper(
    impl
  )
}
