package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class SyncState(
    attachment: Optional[zio.aws.networkfirewall.model.Attachment] =
      Optional.Absent,
    config: Optional[
      Map[ResourceName, zio.aws.networkfirewall.model.PerObjectStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.SyncState = {
    import SyncState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.SyncState
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(
        config.map(value =>
          value
            .map({ case (key, value) =>
              (ResourceName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.config)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.SyncState.ReadOnly =
    zio.aws.networkfirewall.model.SyncState.wrap(buildAwsValue())
}
object SyncState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.SyncState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.SyncState =
      zio.aws.networkfirewall.model.SyncState(
        attachment.map(value => value.asEditable),
        config.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def attachment: Optional[zio.aws.networkfirewall.model.Attachment.ReadOnly]
    def config: Optional[
      Map[ResourceName, zio.aws.networkfirewall.model.PerObjectStatus.ReadOnly]
    ]
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.Attachment.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getConfig: ZIO[Any, AwsError, Map[
      ResourceName,
      zio.aws.networkfirewall.model.PerObjectStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("config", config)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.SyncState
  ) extends zio.aws.networkfirewall.model.SyncState.ReadOnly {
    override val attachment
        : Optional[zio.aws.networkfirewall.model.Attachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachment())
        .map(value => zio.aws.networkfirewall.model.Attachment.wrap(value))
    override val config: Optional[
      Map[ResourceName, zio.aws.networkfirewall.model.PerObjectStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.config())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.networkfirewall.model.primitives.ResourceName(
              key
            ) -> zio.aws.networkfirewall.model.PerObjectStatus.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.SyncState
  ): zio.aws.networkfirewall.model.SyncState.ReadOnly = new Wrapper(impl)
}
