package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters._
sealed trait FirewallStatusValue {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue
}
object FirewallStatusValue {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue
  ): zio.aws.networkfirewall.model.FirewallStatusValue = value match {
    case software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue.READY =>
      val r = READY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.FirewallStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue =
      software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVISIONING
      extends zio.aws.networkfirewall.model.FirewallStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue =
      software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue.PROVISIONING
  }
  case object DELETING
      extends zio.aws.networkfirewall.model.FirewallStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue =
      software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue.DELETING
  }
  case object READY extends zio.aws.networkfirewall.model.FirewallStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue =
      software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue.READY
  }
}
