package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{Setting, Keyword}
import scala.jdk.CollectionConverters._
final case class RuleOption(
    keyword: Keyword,
    settings: Optional[Iterable[Setting]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.RuleOption = {
    import RuleOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.RuleOption
      .builder()
      .keyword(Keyword.unwrap(keyword): java.lang.String)
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            Setting.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.settings)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.RuleOption.ReadOnly =
    zio.aws.networkfirewall.model.RuleOption.wrap(buildAwsValue())
}
object RuleOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.RuleOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.RuleOption =
      zio.aws.networkfirewall.model
        .RuleOption(keyword, settings.map(value => value))
    def keyword: Keyword
    def settings: Optional[List[Setting]]
    def getKeyword: ZIO[Any, Nothing, Keyword] = ZIO.succeed(keyword)
    def getSettings: ZIO[Any, AwsError, List[Setting]] =
      AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleOption
  ) extends zio.aws.networkfirewall.model.RuleOption.ReadOnly {
    override val keyword: Keyword =
      zio.aws.networkfirewall.model.primitives.Keyword(impl.keyword())
    override val settings: Optional[List[Setting]] = zio.aws.core.internal
      .optionalFromNullable(impl.settings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.primitives.Setting(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleOption
  ): zio.aws.networkfirewall.model.RuleOption.ReadOnly = new Wrapper(impl)
}
