package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.{
  RuleCapacity,
  Description,
  ResourceArn,
  NumberOfAssociations,
  ResourceId,
  ResourceName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RuleGroupResponse(
    ruleGroupArn: ResourceArn,
    ruleGroupName: ResourceName,
    ruleGroupId: ResourceId,
    description: Optional[Description] = Optional.Absent,
    `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType] =
      Optional.Absent,
    capacity: Optional[RuleCapacity] = Optional.Absent,
    ruleGroupStatus: Optional[zio.aws.networkfirewall.model.ResourceStatus] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkfirewall.model.Tag]] =
      Optional.Absent,
    consumedCapacity: Optional[RuleCapacity] = Optional.Absent,
    numberOfAssociations: Optional[NumberOfAssociations] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.RuleGroupResponse = {
    import RuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.RuleGroupResponse
      .builder()
      .ruleGroupArn(ResourceArn.unwrap(ruleGroupArn): java.lang.String)
      .ruleGroupName(ResourceName.unwrap(ruleGroupName): java.lang.String)
      .ruleGroupId(ResourceId.unwrap(ruleGroupId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        capacity.map(value => RuleCapacity.unwrap(value): Integer)
      )(_.capacity)
      .optionallyWith(ruleGroupStatus.map(value => value.unwrap))(
        _.ruleGroupStatus
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        consumedCapacity.map(value => RuleCapacity.unwrap(value): Integer)
      )(_.consumedCapacity)
      .optionallyWith(
        numberOfAssociations.map(value =>
          NumberOfAssociations.unwrap(value): Integer
        )
      )(_.numberOfAssociations)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.RuleGroupResponse.ReadOnly =
    zio.aws.networkfirewall.model.RuleGroupResponse.wrap(buildAwsValue())
}
object RuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.RuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.RuleGroupResponse =
      zio.aws.networkfirewall.model.RuleGroupResponse(
        ruleGroupArn,
        ruleGroupName,
        ruleGroupId,
        description.map(value => value),
        `type`.map(value => value),
        capacity.map(value => value),
        ruleGroupStatus.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consumedCapacity.map(value => value),
        numberOfAssociations.map(value => value)
      )
    def ruleGroupArn: ResourceArn
    def ruleGroupName: ResourceName
    def ruleGroupId: ResourceId
    def description: Optional[Description]
    def `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType]
    def capacity: Optional[RuleCapacity]
    def ruleGroupStatus: Optional[zio.aws.networkfirewall.model.ResourceStatus]
    def tags: Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def consumedCapacity: Optional[RuleCapacity]
    def numberOfAssociations: Optional[NumberOfAssociations]
    def getRuleGroupArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(ruleGroupArn)
    def getRuleGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(ruleGroupName)
    def getRuleGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleGroupId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getType
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroupType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCapacity: ZIO[Any, AwsError, RuleCapacity] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getRuleGroupStatus
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.ResourceStatus] =
      AwsError.unwrapOptionField("ruleGroupStatus", ruleGroupStatus)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConsumedCapacity: ZIO[Any, AwsError, RuleCapacity] =
      AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
    def getNumberOfAssociations: ZIO[Any, AwsError, NumberOfAssociations] =
      AwsError.unwrapOptionField("numberOfAssociations", numberOfAssociations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleGroupResponse
  ) extends zio.aws.networkfirewall.model.RuleGroupResponse.ReadOnly {
    override val ruleGroupArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives.ResourceArn(impl.ruleGroupArn())
    override val ruleGroupName: ResourceName =
      zio.aws.networkfirewall.model.primitives
        .ResourceName(impl.ruleGroupName())
    override val ruleGroupId: ResourceId =
      zio.aws.networkfirewall.model.primitives.ResourceId(impl.ruleGroupId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.networkfirewall.model.RuleGroupType.wrap(value))
    override val capacity: Optional[RuleCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.RuleCapacity(value)
      )
    override val ruleGroupStatus
        : Optional[zio.aws.networkfirewall.model.ResourceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroupStatus())
        .map(value => zio.aws.networkfirewall.model.ResourceStatus.wrap(value))
    override val tags
        : Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Tag.wrap(item)
          }.toList
        )
    override val consumedCapacity: Optional[RuleCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedCapacity())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.RuleCapacity(value)
        )
    override val numberOfAssociations: Optional[NumberOfAssociations] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfAssociations())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.NumberOfAssociations(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleGroupResponse
  ): zio.aws.networkfirewall.model.RuleGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
