package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.{
  PaginationMaxResults,
  VpcId,
  PaginationToken
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFirewallsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    vpcIds: Optional[Iterable[VpcId]] = Optional.Absent,
    maxResults: Optional[PaginationMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest = {
    import ListFirewallsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        vpcIds.map(value =>
          value.map { item =>
            VpcId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpcIds)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.ListFirewallsRequest.ReadOnly =
    zio.aws.networkfirewall.model.ListFirewallsRequest.wrap(buildAwsValue())
}
object ListFirewallsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListFirewallsRequest =
      zio.aws.networkfirewall.model.ListFirewallsRequest(
        nextToken.map(value => value),
        vpcIds.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def vpcIds: Optional[List[VpcId]]
    def maxResults: Optional[PaginationMaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVpcIds: ZIO[Any, AwsError, List[VpcId]] =
      AwsError.unwrapOptionField("vpcIds", vpcIds)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest
  ) extends zio.aws.networkfirewall.model.ListFirewallsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val vpcIds: Optional[List[VpcId]] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.primitives.VpcId(item)
        }.toList
      )
    override val maxResults: Optional[PaginationMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.PaginationMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest
  ): zio.aws.networkfirewall.model.ListFirewallsRequest.ReadOnly = new Wrapper(
    impl
  )
}
