package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  Description,
  ResourceName,
  ResourceArn,
  UpdateToken
}
import scala.jdk.CollectionConverters._
final case class UpdateFirewallPolicyRequest(
    updateToken: UpdateToken,
    firewallPolicyArn: Option[ResourceArn] = None,
    firewallPolicyName: Option[ResourceName] = None,
    firewallPolicy: zio.aws.networkfirewall.model.FirewallPolicy,
    description: Option[Description] = None,
    dryRun: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest = {
    import UpdateFirewallPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest
      .builder()
      .updateToken(UpdateToken.unwrap(updateToken): java.lang.String)
      .optionallyWith(
        firewallPolicyArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyArn)
      .optionallyWith(
        firewallPolicyName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyName)
      .firewallPolicy(firewallPolicy.buildAwsValue())
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateFirewallPolicyRequest.ReadOnly =
    zio.aws.networkfirewall.model.UpdateFirewallPolicyRequest
      .wrap(buildAwsValue())
}
object UpdateFirewallPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.UpdateFirewallPolicyRequest =
      zio.aws.networkfirewall.model.UpdateFirewallPolicyRequest(
        updateToken,
        firewallPolicyArn.map(value => value),
        firewallPolicyName.map(value => value),
        firewallPolicy.asEditable,
        description.map(value => value),
        dryRun.map(value => value)
      )
    def updateToken: UpdateToken
    def firewallPolicyArn: Option[ResourceArn]
    def firewallPolicyName: Option[ResourceName]
    def firewallPolicy: zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly
    def description: Option[Description]
    def dryRun: Option[Boolean]
    def getUpdateToken: ZIO[Any, Nothing, UpdateToken] =
      ZIO.succeed(updateToken)
    def getFirewallPolicyArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallPolicyArn", firewallPolicyArn)
    def getFirewallPolicyName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallPolicyName", firewallPolicyName)
    def getFirewallPolicy: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly
    ] = ZIO.succeed(firewallPolicy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest
  ) extends zio.aws.networkfirewall.model.UpdateFirewallPolicyRequest.ReadOnly {
    override val updateToken: UpdateToken =
      zio.aws.networkfirewall.model.primitives.UpdateToken(impl.updateToken())
    override val firewallPolicyArn: Option[ResourceArn] = scala
      .Option(impl.firewallPolicyArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallPolicyName: Option[ResourceName] = scala
      .Option(impl.firewallPolicyName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallPolicy
        : zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly =
      zio.aws.networkfirewall.model.FirewallPolicy.wrap(impl.firewallPolicy())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val dryRun: Option[Boolean] =
      scala.Option(impl.dryRun()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest
  ): zio.aws.networkfirewall.model.UpdateFirewallPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
