package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters._
sealed trait RuleOrder {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.RuleOrder
}
object RuleOrder {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.RuleOrder
  ): zio.aws.networkfirewall.model.RuleOrder = value match {
    case software.amazon.awssdk.services.networkfirewall.model.RuleOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.RuleOrder.DEFAULT_ACTION_ORDER =>
      val r = DEFAULT_ACTION_ORDER
      r
    case software.amazon.awssdk.services.networkfirewall.model.RuleOrder.STRICT_ORDER =>
      val r = STRICT_ORDER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.RuleOrder {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.RuleOrder =
      software.amazon.awssdk.services.networkfirewall.model.RuleOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT_ACTION_ORDER
      extends zio.aws.networkfirewall.model.RuleOrder {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.RuleOrder =
      software.amazon.awssdk.services.networkfirewall.model.RuleOrder.DEFAULT_ACTION_ORDER
  }
  case object STRICT_ORDER extends zio.aws.networkfirewall.model.RuleOrder {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.RuleOrder =
      software.amazon.awssdk.services.networkfirewall.model.RuleOrder.STRICT_ORDER
  }
}
