package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class DescribeLoggingConfigurationResponse(
    firewallArn: Option[ResourceArn] = None,
    loggingConfiguration: Option[
      zio.aws.networkfirewall.model.LoggingConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse = {
    import DescribeLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse
      .builder()
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse.ReadOnly =
    zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse =
      zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse(
        firewallArn.map(value => value),
        loggingConfiguration.map(value => value.asEditable)
      )
    def firewallArn: Option[ResourceArn]
    def loggingConfiguration
        : Option[zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly]
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse
  ) extends zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse.ReadOnly {
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val loggingConfiguration
        : Option[zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly] =
      scala
        .Option(impl.loggingConfiguration())
        .map(value =>
          zio.aws.networkfirewall.model.LoggingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse
  ): zio.aws.networkfirewall.model.DescribeLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
