package zio.aws.networkfirewall.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.Priority
import scala.jdk.CollectionConverters._
final case class StatelessRule(
    ruleDefinition: zio.aws.networkfirewall.model.RuleDefinition,
    priority: Priority
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.StatelessRule = {
    import StatelessRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.StatelessRule
      .builder()
      .ruleDefinition(ruleDefinition.buildAwsValue())
      .priority(Priority.unwrap(priority): Integer)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.StatelessRule.ReadOnly =
    zio.aws.networkfirewall.model.StatelessRule.wrap(buildAwsValue())
}
object StatelessRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.StatelessRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.StatelessRule =
      zio.aws.networkfirewall.model
        .StatelessRule(ruleDefinition.asEditable, priority)
    def ruleDefinition: zio.aws.networkfirewall.model.RuleDefinition.ReadOnly
    def priority: Priority
    def getRuleDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.RuleDefinition.ReadOnly
    ] = ZIO.succeed(ruleDefinition)
    def getPriority: ZIO[Any, Nothing, Priority] = ZIO.succeed(priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatelessRule
  ) extends zio.aws.networkfirewall.model.StatelessRule.ReadOnly {
    override val ruleDefinition
        : zio.aws.networkfirewall.model.RuleDefinition.ReadOnly =
      zio.aws.networkfirewall.model.RuleDefinition.wrap(impl.ruleDefinition())
    override val priority: Priority =
      zio.aws.networkfirewall.model.primitives.Priority(impl.priority())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatelessRule
  ): zio.aws.networkfirewall.model.StatelessRule.ReadOnly = new Wrapper(impl)
}
