package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.CollectionMember_String
import scala.jdk.CollectionConverters._
final case class FirewallPolicy(
    statelessRuleGroupReferences: Option[
      Iterable[zio.aws.networkfirewall.model.StatelessRuleGroupReference]
    ] = None,
    statelessDefaultActions: Iterable[CollectionMember_String],
    statelessFragmentDefaultActions: Iterable[CollectionMember_String],
    statelessCustomActions: Option[
      Iterable[zio.aws.networkfirewall.model.CustomAction]
    ] = None,
    statefulRuleGroupReferences: Option[
      Iterable[zio.aws.networkfirewall.model.StatefulRuleGroupReference]
    ] = None,
    statefulDefaultActions: Option[Iterable[CollectionMember_String]] = None,
    statefulEngineOptions: Option[
      zio.aws.networkfirewall.model.StatefulEngineOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy = {
    import FirewallPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy
      .builder()
      .optionallyWith(
        statelessRuleGroupReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessRuleGroupReferences)
      .statelessDefaultActions(statelessDefaultActions.map { item =>
        CollectionMember_String.unwrap(item): java.lang.String
      }.asJavaCollection)
      .statelessFragmentDefaultActions(statelessFragmentDefaultActions.map {
        item =>
          CollectionMember_String.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        statelessCustomActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessCustomActions)
      .optionallyWith(
        statefulRuleGroupReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statefulRuleGroupReferences)
      .optionallyWith(
        statefulDefaultActions.map(value =>
          value.map { item =>
            CollectionMember_String.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statefulDefaultActions)
      .optionallyWith(
        statefulEngineOptions.map(value => value.buildAwsValue())
      )(_.statefulEngineOptions)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly =
    zio.aws.networkfirewall.model.FirewallPolicy.wrap(buildAwsValue())
}
object FirewallPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.FirewallPolicy =
      zio.aws.networkfirewall.model.FirewallPolicy(
        statelessRuleGroupReferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessDefaultActions,
        statelessFragmentDefaultActions,
        statelessCustomActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statefulRuleGroupReferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statefulDefaultActions.map(value => value),
        statefulEngineOptions.map(value => value.asEditable)
      )
    def statelessRuleGroupReferences: Option[
      List[zio.aws.networkfirewall.model.StatelessRuleGroupReference.ReadOnly]
    ]
    def statelessDefaultActions: List[CollectionMember_String]
    def statelessFragmentDefaultActions: List[CollectionMember_String]
    def statelessCustomActions
        : Option[List[zio.aws.networkfirewall.model.CustomAction.ReadOnly]]
    def statefulRuleGroupReferences: Option[
      List[zio.aws.networkfirewall.model.StatefulRuleGroupReference.ReadOnly]
    ]
    def statefulDefaultActions: Option[List[CollectionMember_String]]
    def statefulEngineOptions
        : Option[zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly]
    def getStatelessRuleGroupReferences: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.StatelessRuleGroupReference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statelessRuleGroupReferences",
      statelessRuleGroupReferences
    )
    def getStatelessDefaultActions
        : ZIO[Any, Nothing, List[CollectionMember_String]] =
      ZIO.succeed(statelessDefaultActions)
    def getStatelessFragmentDefaultActions
        : ZIO[Any, Nothing, List[CollectionMember_String]] =
      ZIO.succeed(statelessFragmentDefaultActions)
    def getStatelessCustomActions: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.CustomAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statelessCustomActions",
      statelessCustomActions
    )
    def getStatefulRuleGroupReferences: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.StatefulRuleGroupReference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statefulRuleGroupReferences",
      statefulRuleGroupReferences
    )
    def getStatefulDefaultActions
        : ZIO[Any, AwsError, List[CollectionMember_String]] = AwsError
      .unwrapOptionField("statefulDefaultActions", statefulDefaultActions)
    def getStatefulEngineOptions: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("statefulEngineOptions", statefulEngineOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy
  ) extends zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly {
    override val statelessRuleGroupReferences: Option[
      List[zio.aws.networkfirewall.model.StatelessRuleGroupReference.ReadOnly]
    ] = scala
      .Option(impl.statelessRuleGroupReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.StatelessRuleGroupReference.wrap(item)
        }.toList
      )
    override val statelessDefaultActions: List[CollectionMember_String] = impl
      .statelessDefaultActions()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.primitives.CollectionMember_String(item)
      }
      .toList
    override val statelessFragmentDefaultActions
        : List[CollectionMember_String] = impl
      .statelessFragmentDefaultActions()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.primitives.CollectionMember_String(item)
      }
      .toList
    override val statelessCustomActions
        : Option[List[zio.aws.networkfirewall.model.CustomAction.ReadOnly]] =
      scala
        .Option(impl.statelessCustomActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.CustomAction.wrap(item)
          }.toList
        )
    override val statefulRuleGroupReferences: Option[
      List[zio.aws.networkfirewall.model.StatefulRuleGroupReference.ReadOnly]
    ] = scala
      .Option(impl.statefulRuleGroupReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.StatefulRuleGroupReference.wrap(item)
        }.toList
      )
    override val statefulDefaultActions: Option[List[CollectionMember_String]] =
      scala
        .Option(impl.statefulDefaultActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.primitives
              .CollectionMember_String(item)
          }.toList
        )
    override val statefulEngineOptions
        : Option[zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly] =
      scala
        .Option(impl.statefulEngineOptions())
        .map(value =>
          zio.aws.networkfirewall.model.StatefulEngineOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallPolicy
  ): zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly = new Wrapper(impl)
}
