/*
 * Decompiled with CFR 0.152.
 */
package zio.aws.netty.descriptors;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslProvider;
import java.io.Serializable;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple14;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.utils.AttributeMap;
import zio.Chunk;
import zio.Config;
import zio.Config$;
import zio.DurationSyntax$;
import zio.Zippable$;
import zio.aws.core.httpclient.ChannelOptions;
import zio.aws.core.httpclient.Protocol;
import zio.aws.netty.Http2Config;
import zio.aws.netty.HttpOrHttps;
import zio.aws.netty.HttpOrHttps$Http$;
import zio.aws.netty.HttpOrHttps$Https$;
import zio.aws.netty.NettyChannelOptions;
import zio.aws.netty.NettyClientConfig;
import zio.aws.netty.NettyOptionValue;
import zio.aws.netty.ProxyConfiguration;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final Config<HttpOrHttps> httpOrHttps = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)x0$1 -> {
        String string = x0$1;
        if ("http".equals(string)) {
            return scala.package$.MODULE$.Right().apply((Object)HttpOrHttps$Http$.MODULE$);
        }
        if ("https".equals(string)) {
            return scala.package$.MODULE$.Right().apply((Object)HttpOrHttps$Https$.MODULE$);
        }
        if (string != null) {
            String string2 = string;
            String x$1 = new StringBuilder(37).append("Invalid value ").append(string2).append(". Use 'http' or 'https'").toString();
            Chunk x$2 = Config.Error$.InvalidData$.MODULE$.apply$default$1();
            return scala.package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(x$2, x$1));
        }
        throw new MatchError((Object)string);
    });
    private static final Config<ProxyConfiguration> proxyConfiguration = MODULE$.httpOrHttps().nested((Function0 & Serializable)() -> "scheme").withDefault((Function0 & Serializable)() -> HttpOrHttps$Http$.MODULE$).$qmark$qmark((Function0 & Serializable)() -> "The proxy scheme").zip((Function0 & Serializable)() -> Config$.MODULE$.string("host").$qmark$qmark((Function0 & Serializable)() -> "Hostname of the proxy"), Zippable$.MODULE$.Zippable2()).zip((Function0 & Serializable)() -> Config$.MODULE$.int("port").$qmark$qmark((Function0 & Serializable)() -> "Port of the proxy"), Zippable$.MODULE$.Zippable3()).zip((Function0 & Serializable)() -> Config$.MODULE$.setOf("nonProxyHosts", Config$.MODULE$.string()).withDefault((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty()).$qmark$qmark((Function0 & Serializable)() -> "Hosts that should not be proxied"), Zippable$.MODULE$.Zippable4()).map((Function1 & Serializable)x0$2 -> {
        Tuple4 tuple4 = x0$2;
        if (tuple4 != null) {
            HttpOrHttps scheme = (HttpOrHttps)tuple4._1();
            String host = (String)tuple4._2();
            int port = BoxesRunTime.unboxToInt((Object)tuple4._3());
            Set nonProxyHosts = (Set)tuple4._4();
            return new ProxyConfiguration(scheme, host, port, (Set<String>)nonProxyHosts);
        }
        throw new MatchError((Object)tuple4);
    });
    private static final Config<Http2Config> http2Configuration = Config$.MODULE$.int("maxStreams").$qmark$qmark((Function0 & Serializable)() -> "Max number of concurrent streams per connection").zip((Function0 & Serializable)() -> Config$.MODULE$.int("initialWindowSize").$qmark$qmark((Function0 & Serializable)() -> "Initial window size of a stream"), Zippable$.MODULE$.Zippable2()).zip((Function0 & Serializable)() -> Config$.MODULE$.duration("healthCheckPingPeriod").withDefault((Function0 & Serializable)() -> DurationSyntax$.MODULE$.seconds$extension(zio.package$.MODULE$.durationInt(5))).$qmark$qmark((Function0 & Serializable)() -> "The period that the Netty client will send PING frames to the remote endpoint"), Zippable$.MODULE$.Zippable3()).map((Function1 & Serializable)x0$3 -> {
        Tuple3 tuple3 = x0$3;
        if (tuple3 != null) {
            int maxStreams = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int initialWindowSize = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Duration healthCheckPingPeriod = (Duration)tuple3._3();
            return new Http2Config(maxStreams, initialWindowSize, healthCheckPingPeriod);
        }
        throw new MatchError((Object)tuple3);
    });
    private static final Config<NettyChannelOptions> nettyChannelOptions;
    private static final Config<Protocol> protocol;
    private static final Config<SslProvider> sslProvider;
    private static final Config<NettyClientConfig> nettyClientConfig;

    static {
        Config socketChannelOptions = zio.aws.core.httpclient.descriptors.package$.MODULE$.channelOptions();
        Config channelOptions = MODULE$.durationMsChannelOption((ChannelOption<Integer>)ChannelOption.CONNECT_TIMEOUT_MILLIS).$qmark$qmark((Function0 & Serializable)() -> "Connect timeout").zip((Function0 & Serializable)() -> MODULE$.intChannelOption((ChannelOption<Integer>)ChannelOption.WRITE_SPIN_COUNT).$qmark$qmark((Function0 & Serializable)() -> "Write spin count"), Zippable$.MODULE$.Zippable2()).zip((Function0 & Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.ALLOW_HALF_CLOSURE).$qmark$qmark((Function0 & Serializable)() -> "Allow half closure"), Zippable$.MODULE$.Zippable3()).zip((Function0 & Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.AUTO_READ).$qmark$qmark((Function0 & Serializable)() -> "Auto read"), Zippable$.MODULE$.Zippable4()).zip((Function0 & Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.AUTO_CLOSE).$qmark$qmark((Function0 & Serializable)() -> "Auto close"), Zippable$.MODULE$.Zippable5()).zip((Function0 & Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP).$qmark$qmark((Function0 & Serializable)() -> "Single event executor per group"), Zippable$.MODULE$.Zippable6()).map((Function1 & Serializable)tuple -> new NettyChannelOptions(tuple.productIterator().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Some some;
                Object opt;
                A1 A1 = x1;
                if (A1 instanceof Some && (opt = (some = (Some)A1).value()) instanceof NettyOptionValue) {
                    NettyOptionValue nettyOptionValue = (NettyOptionValue)opt;
                    return (B1)nettyOptionValue;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Some some;
                Object opt;
                Object object = x1;
                return object instanceof Some && (opt = (some = (Some)object).value()) instanceof NettyOptionValue;
            }
        }).toVector()));
        nettyChannelOptions = socketChannelOptions.zip((Function0 & Serializable)() -> channelOptions, Zippable$.MODULE$.Zippable2()).mapOrFail((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                ChannelOptions opts1 = (ChannelOptions)tuple2._1();
                NettyChannelOptions opts2 = (NettyChannelOptions)tuple2._2();
                return scala.package$.MODULE$.Right().apply((Object)opts2.withSocketOptions(opts1));
            }
            throw new MatchError((Object)tuple2);
        });
        protocol = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)x0$5 -> {
            String string = x0$5;
            if ("HTTP/1.1".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)Protocol.Http11$.MODULE$);
            }
            if ("HTTP/2".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)Protocol.Http2$.MODULE$);
            }
            if ("Dual".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)Protocol.Dual$.MODULE$);
            }
            if (string != null) {
                String string2 = string;
                String x$3 = new StringBuilder(58).append("Invalid protocol: '").append(string2).append("'. Use 'HTTP/1.1' or 'HTTP/2' or 'Dual'").toString();
                Chunk x$4 = Config.Error$.InvalidData$.MODULE$.apply$default$1();
                return scala.package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(x$4, x$3));
            }
            throw new MatchError((Object)string);
        });
        sslProvider = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)x0$6 -> {
            String string = x0$6;
            if ("JDK".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)SslProvider.JDK);
            }
            if ("OPENSSL".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)SslProvider.OPENSSL);
            }
            if ("OPENSSL_REFCNT".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)SslProvider.OPENSSL_REFCNT);
            }
            if (string != null) {
                String string2 = string;
                String x$5 = new StringBuilder(66).append("Invalid SSL provider: '").append(string2).append("'. Use 'JDK', 'OPENSSL' or 'OPENSSL_REFCNT'").toString();
                Chunk x$6 = Config.Error$.InvalidData$.MODULE$.apply$default$1();
                return scala.package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(x$6, x$5));
            }
            throw new MatchError((Object)string);
        });
        nettyClientConfig = Config$.MODULE$.int("maxConcurrency").withDefault((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int((Integer)package$.globalDefault$1(SdkHttpConfigurationOption.MAX_CONNECTIONS))).$qmark$qmark((Function0 & Serializable)() -> "Maximum number of allowed concurrent requests").zip((Function0 & Serializable)() -> Config$.MODULE$.int("maxPendingConnectionAcquires").withDefault((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int((Integer)package$.globalDefault$1(SdkHttpConfigurationOption.MAX_PENDING_CONNECTION_ACQUIRES))).$qmark$qmark((Function0 & Serializable)() -> "The maximum number of pending acquires allowed"), Zippable$.MODULE$.Zippable2()).zip((Function0 & Serializable)() -> Config$.MODULE$.duration("readTimeout").withDefault((Function0 & Serializable)() -> (Duration)package$.globalDefault$1(SdkHttpConfigurationOption.READ_TIMEOUT)).$qmark$qmark((Function0 & Serializable)() -> "The amount of time to wait for a read on a socket"), Zippable$.MODULE$.Zippable3()).zip((Function0 & Serializable)() -> Config$.MODULE$.duration("writeTimeout").withDefault((Function0 & Serializable)() -> (Duration)package$.globalDefault$1(SdkHttpConfigurationOption.WRITE_TIMEOUT)).$qmark$qmark((Function0 & Serializable)() -> "The amount of time to wait for a write on a socket"), Zippable$.MODULE$.Zippable4()).zip((Function0 & Serializable)() -> Config$.MODULE$.duration("connectionTimeout").withDefault((Function0 & Serializable)() -> (Duration)package$.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).$qmark$qmark((Function0 & Serializable)() -> "The amount of time to wait when initially establishing a connection before giving up"), Zippable$.MODULE$.Zippable5()).zip((Function0 & Serializable)() -> Config$.MODULE$.duration("connectionAcquisitionTimeout").withDefault((Function0 & Serializable)() -> (Duration)package$.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT)).$qmark$qmark((Function0 & Serializable)() -> "The amount of time to wait when acquiring a connection from the pool before giving up"), Zippable$.MODULE$.Zippable6()).zip((Function0 & Serializable)() -> Config$.MODULE$.duration("connectionTimeToLive").withDefault((Function0 & Serializable)() -> (Duration)package$.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE)).$qmark$qmark((Function0 & Serializable)() -> "The maximum amount of time that a connection should be allowed to remain open, regardless of usage frequency"), Zippable$.MODULE$.Zippable7()).zip((Function0 & Serializable)() -> Config$.MODULE$.duration("connectionMaxIdleTime").withDefault((Function0 & Serializable)() -> DurationSyntax$.MODULE$.seconds$extension(zio.package$.MODULE$.durationInt(5))).$qmark$qmark((Function0 & Serializable)() -> "Maximum amount of time that a connection should be allowed to remain open while idle"), Zippable$.MODULE$.Zippable8()).zip((Function0 & Serializable)() -> Config$.MODULE$.boolean("useIdleConnectionReaper").withDefault((Function0)(JFunction0.mcZ.sp & Serializable)() -> (Boolean)package$.globalDefault$1(SdkHttpConfigurationOption.REAP_IDLE_CONNECTIONS)).$qmark$qmark((Function0 & Serializable)() -> "If true, the idle connections in the pool should be closed"), Zippable$.MODULE$.Zippable9()).zip((Function0 & Serializable)() -> MODULE$.protocol().nested((Function0 & Serializable)() -> "protocol").withDefault((Function0 & Serializable)() -> Protocol.Dual$.MODULE$).$qmark$qmark((Function0 & Serializable)() -> "HTTP/1.1 or HTTP/2 or Dual"), Zippable$.MODULE$.Zippable10()).zip((Function0 & Serializable)() -> MODULE$.nettyChannelOptions().nested((Function0 & Serializable)() -> "channelOptions").withDefault((Function0 & Serializable)() -> new NettyChannelOptions(scala.package$.MODULE$.Vector().empty())).$qmark$qmark((Function0 & Serializable)() -> "Custom Netty channel options"), Zippable$.MODULE$.Zippable11()).zip((Function0 & Serializable)() -> MODULE$.sslProvider().nested((Function0 & Serializable)() -> "sslProvider").optional().$qmark$qmark((Function0 & Serializable)() -> "The SSL provider to be used"), Zippable$.MODULE$.Zippable12()).zip((Function0 & Serializable)() -> MODULE$.proxyConfiguration().nested((Function0 & Serializable)() -> "proxy").optional().$qmark$qmark((Function0 & Serializable)() -> "Proxy configuration"), Zippable$.MODULE$.Zippable13()).zip((Function0 & Serializable)() -> MODULE$.http2Configuration().nested((Function0 & Serializable)() -> "http2").optional().$qmark$qmark((Function0 & Serializable)() -> "HTTP/2 specific options"), Zippable$.MODULE$.Zippable14()).map((Function1 & Serializable)x0$7 -> {
            Tuple14 tuple14 = x0$7;
            if (tuple14 != null) {
                int maxConcurrency = BoxesRunTime.unboxToInt((Object)tuple14._1());
                int maxPendingConnectionAcquires = BoxesRunTime.unboxToInt((Object)tuple14._2());
                Duration readTimeout = (Duration)tuple14._3();
                Duration writeTimeout = (Duration)tuple14._4();
                Duration connectionTimeout = (Duration)tuple14._5();
                Duration connectionAcquisitionTimeout = (Duration)tuple14._6();
                Duration connectionTimeToLive = (Duration)tuple14._7();
                Duration connectionMaxIdleTime = (Duration)tuple14._8();
                boolean useIdleConnectionReaper = BoxesRunTime.unboxToBoolean((Object)tuple14._9());
                Protocol protocol = (Protocol)tuple14._10();
                NettyChannelOptions channelOptions = (NettyChannelOptions)tuple14._11();
                Option sslProvider = (Option)tuple14._12();
                Option proxyConfiguration = (Option)tuple14._13();
                Option http2Configuration = (Option)tuple14._14();
                return new NettyClientConfig(maxConcurrency, maxPendingConnectionAcquires, readTimeout, writeTimeout, connectionTimeout, connectionAcquisitionTimeout, connectionTimeToLive, connectionMaxIdleTime, useIdleConnectionReaper, protocol, channelOptions, (Option<SslProvider>)sslProvider, (Option<ProxyConfiguration>)proxyConfiguration, (Option<Http2Config>)http2Configuration);
            }
            throw new MatchError((Object)tuple14);
        });
    }

    public Config<HttpOrHttps> httpOrHttps() {
        return httpOrHttps;
    }

    public Config<ProxyConfiguration> proxyConfiguration() {
        return proxyConfiguration;
    }

    public Config<Http2Config> http2Configuration() {
        return http2Configuration;
    }

    public <T, JT> Config<Option<NettyOptionValue<JT>>> channelOption(ChannelOption<JT> opt, Function1<T, JT> toJava, Config<T> desc) {
        return desc.nested((Function0 & Serializable)() -> opt.name()).optional().map((Function1 & Serializable)x$1 -> x$1.map((Function1 & Serializable)value -> new NettyOptionValue<Object>(opt, toJava.apply(value))));
    }

    public Config<Option<NettyOptionValue<Boolean>>> boolChannelOption(ChannelOption<Boolean> opt) {
        return this.channelOption(opt, (Function1 & Serializable)b -> BoxesRunTime.unboxToBoolean((Object)b), Config$.MODULE$.boolean());
    }

    public Config<Option<NettyOptionValue<Integer>>> intChannelOption(ChannelOption<Integer> opt) {
        return this.channelOption(opt, (Function1 & Serializable)i -> BoxesRunTime.unboxToInt((Object)i), Config$.MODULE$.int());
    }

    public Config<Option<NettyOptionValue<Integer>>> durationMsChannelOption(ChannelOption<Integer> opt) {
        return this.channelOption(opt, (Function1 & Serializable)d -> (int)d.toMillis(), Config$.MODULE$.duration());
    }

    public Config<NettyChannelOptions> nettyChannelOptions() {
        return nettyChannelOptions;
    }

    public Config<Protocol> protocol() {
        return protocol;
    }

    public Config<SslProvider> sslProvider() {
        return sslProvider;
    }

    public Config<NettyClientConfig> nettyClientConfig() {
        return nettyClientConfig;
    }

    private static final Object globalDefault$1(SdkHttpConfigurationOption key) {
        return SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS.get((AttributeMap.Key)key);
    }

    private package$() {
    }
}

