/*
 * Decompiled with CFR 0.152.
 */
package zio.aws.netty.descriptors;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslProvider;
import java.io.Serializable;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple14;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.utils.AttributeMap;
import zio.DurationSyntax$;
import zio.aws.core.httpclient.ChannelOptions;
import zio.aws.core.httpclient.Protocol;
import zio.aws.netty.Http2Config;
import zio.aws.netty.HttpOrHttps;
import zio.aws.netty.HttpOrHttps$Http$;
import zio.aws.netty.HttpOrHttps$Https$;
import zio.aws.netty.NettyChannelOptions;
import zio.aws.netty.NettyClientConfig;
import zio.aws.netty.NettyOptionValue;
import zio.aws.netty.ProxyConfiguration;
import zio.config.ConfigDescriptorModule;
import zio.config.InvariantZip$;
import zio.config.TupleConversion;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final ConfigDescriptorModule.ConfigDescriptor<HttpOrHttps> httpOrHttps = zio.config.package$.MODULE$.ConfigDescriptor().string().transformOrFail((Function1 & Serializable)x0$1 -> {
        String string = x0$1;
        if ("http".equals(string)) {
            return scala.package$.MODULE$.Right().apply((Object)HttpOrHttps$Http$.MODULE$);
        }
        if ("https".equals(string)) {
            return scala.package$.MODULE$.Right().apply((Object)HttpOrHttps$Https$.MODULE$);
        }
        if (string != null) {
            String string2 = string;
            return scala.package$.MODULE$.Left().apply((Object)new StringBuilder(37).append("Invalid value ").append(string2).append(". Use 'http' or 'https'").toString());
        }
        throw new MatchError((Object)string);
    }, (Function1 & Serializable)value -> scala.package$.MODULE$.Right().apply((Object)value.asString()));
    private static final ConfigDescriptorModule.ConfigDescriptor<ProxyConfiguration> proxyConfiguration;
    private static final ConfigDescriptorModule.ConfigDescriptor<Http2Config> http2Configuration;
    private static final ConfigDescriptorModule.ConfigDescriptor<NettyChannelOptions> nettyChannelOptions;
    private static final ConfigDescriptorModule.ConfigDescriptor<Protocol> protocol;
    private static final ConfigDescriptorModule.ConfigDescriptor<SslProvider> sslProvider;
    private static final ConfigDescriptorModule.ConfigDescriptor<NettyClientConfig> nettyClientConfig;

    static {
        String x$1 = "scheme";
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> MODULE$.httpOrHttps();
        Option x$32 = zio.config.package$.MODULE$.ConfigDescriptor().nested$default$3("scheme");
        proxyConfiguration = zio.config.package$.MODULE$.ConfigDescriptor().nested("scheme", (Function0)x$2, x$32).default((Object)HttpOrHttps$Http$.MODULE$).$qmark$qmark("The proxy scheme").zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().string("host").$qmark$qmark("Hostname of the proxy"), InvariantZip$.MODULE$.invariantZipAB()).zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().int("port").$qmark$qmark("Port of the proxy"), InvariantZip$.MODULE$.invariantZipTuple2()).zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().set("nonProxyHosts", (Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().string()).default((Object)Predef$.MODULE$.Set().empty()).$qmark$qmark("Hosts that should not be proxied"), InvariantZip$.MODULE$.invariantZipTuple3()).to((TupleConversion)new TupleConversion<ProxyConfiguration, Tuple4<HttpOrHttps, String, Object, Set<String>>>(){

            public Tuple4<HttpOrHttps, String, Object, Set<String>> to(ProxyConfiguration a) {
                return new Tuple4((Object)a.scheme(), (Object)a.host(), (Object)BoxesRunTime.boxToInteger((int)a.port()), a.nonProxyHosts());
            }

            public ProxyConfiguration from(Tuple4<HttpOrHttps, String, Object, Set<String>> b) {
                return new ProxyConfiguration((HttpOrHttps)b._1(), (String)b._2(), BoxesRunTime.unboxToInt((Object)b._3()), (Set<String>)((Set)b._4()));
            }
        });
        http2Configuration = zio.config.package$.MODULE$.ConfigDescriptor().long("maxStreams").$qmark$qmark("Max number of concurrent streams per connection").zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().int("initialWindowSize").$qmark$qmark("Initial window size of a stream"), InvariantZip$.MODULE$.invariantZipAB()).zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().zioDuration("healthCheckPingPeriod").default((Object)DurationSyntax$.MODULE$.seconds$extension(zio.package$.MODULE$.durationInt(5))).$qmark$qmark("The period that the Netty client will send PING frames to the remote endpoint"), InvariantZip$.MODULE$.invariantZipTuple2()).to((TupleConversion)new TupleConversion<Http2Config, Tuple3<Object, Object, Duration>>(){

            public Tuple3<Object, Object, Duration> to(Http2Config a) {
                return new Tuple3((Object)BoxesRunTime.boxToLong((long)a.maxStreams()), (Object)BoxesRunTime.boxToInteger((int)a.initialWindowSize()), (Object)a.healthCheckPingPeriod());
            }

            public Http2Config from(Tuple3<Object, Object, Duration> b) {
                return new Http2Config(BoxesRunTime.unboxToLong((Object)b._1()), BoxesRunTime.unboxToInt((Object)b._2()), (Duration)b._3());
            }
        });
        ConfigDescriptorModule.ConfigDescriptor socketChannelOptions = zio.aws.core.httpclient.descriptors.package$.MODULE$.channelOptions();
        ConfigDescriptorModule.ConfigDescriptor channelOptions2 = MODULE$.durationMsChannelOption((ChannelOption<Integer>)ChannelOption.CONNECT_TIMEOUT_MILLIS).$qmark$qmark("Connect timeout").zip((Function0 & Serializable)() -> MODULE$.intChannelOption((ChannelOption<Integer>)ChannelOption.WRITE_SPIN_COUNT).$qmark$qmark("Write spin count"), InvariantZip$.MODULE$.invariantZipAB()).zip((Function0 & Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.ALLOW_HALF_CLOSURE).$qmark$qmark("Allow half closure"), InvariantZip$.MODULE$.invariantZipTuple2()).zip((Function0 & Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.AUTO_READ).$qmark$qmark("Auto read"), InvariantZip$.MODULE$.invariantZipTuple3()).zip((Function0 & Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.AUTO_CLOSE).$qmark$qmark("Auto close"), InvariantZip$.MODULE$.invariantZipTuple4()).zip((Function0 & Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP).$qmark$qmark("Single event executor per group"), InvariantZip$.MODULE$.invariantZipTuple5()).transform((Function1 & Serializable)tuple -> new NettyChannelOptions(tuple.productIterator().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Some some;
                Object opt;
                A1 A1 = x1;
                if (A1 instanceof Some && (opt = (some = (Some)A1).value()) instanceof NettyOptionValue) {
                    NettyOptionValue nettyOptionValue = (NettyOptionValue)opt;
                    return (B1)nettyOptionValue;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Some some;
                Object opt;
                Object object = x1;
                return object instanceof Some && (opt = (some = (Some)object).value()) instanceof NettyOptionValue;
            }
        }).toVector()), (Function1 & Serializable)channelOptions -> new Tuple6((Object)package$.findOpt$1(channelOptions, ChannelOption.CONNECT_TIMEOUT_MILLIS), (Object)package$.findOpt$1(channelOptions, ChannelOption.WRITE_SPIN_COUNT), (Object)package$.findOpt$1(channelOptions, ChannelOption.ALLOW_HALF_CLOSURE), (Object)package$.findOpt$1(channelOptions, ChannelOption.AUTO_READ), (Object)package$.findOpt$1(channelOptions, ChannelOption.AUTO_CLOSE), (Object)package$.findOpt$1(channelOptions, ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP)));
        nettyChannelOptions = socketChannelOptions.zip((Function0 & Serializable)() -> channelOptions2, InvariantZip$.MODULE$.invariantZipAB()).transformOrFail((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                ChannelOptions opts1 = (ChannelOptions)tuple2._1();
                NettyChannelOptions opts2 = (NettyChannelOptions)tuple2._2();
                return scala.package$.MODULE$.Right().apply((Object)opts2.withSocketOptions(opts1));
            }
            throw new MatchError((Object)tuple2);
        }, (Function1 & Serializable)x$3 -> scala.package$.MODULE$.Left().apply((Object)"not supported"));
        protocol = zio.config.package$.MODULE$.ConfigDescriptor().string().transformOrFail((Function1 & Serializable)x0$3 -> {
            String string = x0$3;
            if ("HTTP/1.1".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)Protocol.Http11$.MODULE$);
            }
            if ("HTTP/2".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)Protocol.Http2$.MODULE$);
            }
            if ("Dual".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)Protocol.Dual$.MODULE$);
            }
            if (string != null) {
                String string2 = string;
                return scala.package$.MODULE$.Left().apply((Object)new StringBuilder(58).append("Invalid protocol: '").append(string2).append("'. Use 'HTTP/1.1' or 'HTTP/2' or 'Dual'").toString());
            }
            throw new MatchError((Object)string);
        }, (Function1 & Serializable)x0$4 -> {
            Protocol protocol = x0$4;
            if (Protocol.Http11$.MODULE$.equals(protocol)) {
                return scala.package$.MODULE$.Right().apply((Object)"HTTP/1.1");
            }
            if (Protocol.Http2$.MODULE$.equals(protocol)) {
                return scala.package$.MODULE$.Right().apply((Object)"HTTP/2");
            }
            if (Protocol.Dual$.MODULE$.equals(protocol)) {
                return scala.package$.MODULE$.Right().apply((Object)"Dual");
            }
            throw new MatchError((Object)protocol);
        });
        sslProvider = zio.config.package$.MODULE$.ConfigDescriptor().string().transformOrFail((Function1 & Serializable)x0$5 -> {
            String string = x0$5;
            if ("JDK".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)SslProvider.JDK);
            }
            if ("OPENSSL".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)SslProvider.OPENSSL);
            }
            if ("OPENSSL_REFCNT".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)SslProvider.OPENSSL_REFCNT);
            }
            if (string != null) {
                String string2 = string;
                return scala.package$.MODULE$.Left().apply((Object)new StringBuilder(66).append("Invalid SSL provider: '").append(string2).append("'. Use 'JDK', 'OPENSSL' or 'OPENSSL_REFCNT'").toString());
            }
            throw new MatchError((Object)string);
        }, (Function1 & Serializable)x0$6 -> {
            SslProvider sslProvider = x0$6;
            if (SslProvider.JDK.equals(sslProvider)) {
                return scala.package$.MODULE$.Right().apply((Object)"JDK");
            }
            if (SslProvider.OPENSSL.equals(sslProvider)) {
                return scala.package$.MODULE$.Right().apply((Object)"OPENSSL");
            }
            if (SslProvider.OPENSSL_REFCNT.equals(sslProvider)) {
                return scala.package$.MODULE$.Right().apply((Object)"OPENSSL_REFCNT");
            }
            throw new MatchError((Object)sslProvider);
        });
        nettyClientConfig = zio.config.package$.MODULE$.ConfigDescriptor().int("maxConcurrency").default((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)package$.globalDefault$1(SdkHttpConfigurationOption.MAX_CONNECTIONS)))).$qmark$qmark("Maximum number of allowed concurrent requests").zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().int("maxPendingConnectionAcquires").default((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)package$.globalDefault$1(SdkHttpConfigurationOption.MAX_PENDING_CONNECTION_ACQUIRES)))).$qmark$qmark("The maximum number of pending acquires allowed"), InvariantZip$.MODULE$.invariantZipAB()).zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().zioDuration("readTimeout").default(package$.globalDefault$1(SdkHttpConfigurationOption.READ_TIMEOUT)).$qmark$qmark("The amount of time to wait for a read on a socket"), InvariantZip$.MODULE$.invariantZipTuple2()).zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().zioDuration("writeTimeout").default(package$.globalDefault$1(SdkHttpConfigurationOption.WRITE_TIMEOUT)).$qmark$qmark("The amount of time to wait for a write on a socket"), InvariantZip$.MODULE$.invariantZipTuple3()).zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().zioDuration("connectionTimeout").default(package$.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).$qmark$qmark("The amount of time to wait when initially establishing a connection before giving up"), InvariantZip$.MODULE$.invariantZipTuple4()).zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().zioDuration("connectionAcquisitionTimeout").default(package$.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT)).$qmark$qmark("The amount of time to wait when acquiring a connection from the pool before giving up"), InvariantZip$.MODULE$.invariantZipTuple5()).zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().zioDuration("connectionTimeToLive").default(package$.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE)).$qmark$qmark("The maximum amount of time that a connection should be allowed to remain open, regardless of usage frequency"), InvariantZip$.MODULE$.invariantZipTuple6()).zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().zioDuration("connectionMaxIdleTime").default((Object)DurationSyntax$.MODULE$.seconds$extension(zio.package$.MODULE$.durationInt(5))).$qmark$qmark("Maximum amount of time that a connection should be allowed to remain open while idle"), InvariantZip$.MODULE$.invariantZipTuple7()).zip((Function0 & Serializable)() -> zio.config.package$.MODULE$.ConfigDescriptor().boolean("useIdleConnectionReaper").default((Object)BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean((Boolean)package$.globalDefault$1(SdkHttpConfigurationOption.REAP_IDLE_CONNECTIONS)))).$qmark$qmark("If true, the idle connections in the pool should be closed"), InvariantZip$.MODULE$.invariantZipTuple8()).zip((Function0 & Serializable)() -> {
            String x$4 = "protocol";
            Function0 & Serializable x$5 = (Function0 & Serializable)() -> MODULE$.protocol();
            Option x$6 = zio.config.package$.MODULE$.ConfigDescriptor().nested$default$3("protocol");
            return zio.config.package$.MODULE$.ConfigDescriptor().nested("protocol", (Function0)x$5, x$6).default((Object)Protocol.Dual$.MODULE$).$qmark$qmark("HTTP/1.1 or HTTP/2 or Dual");
        }, InvariantZip$.MODULE$.invariantZipTuple9()).zip((Function0 & Serializable)() -> {
            String x$7 = "channelOptions";
            Function0 & Serializable x$8 = (Function0 & Serializable)() -> MODULE$.nettyChannelOptions();
            Option x$9 = zio.config.package$.MODULE$.ConfigDescriptor().nested$default$3("channelOptions");
            return zio.config.package$.MODULE$.ConfigDescriptor().nested("channelOptions", (Function0)x$8, x$9).default((Object)new NettyChannelOptions(scala.package$.MODULE$.Vector().empty())).$qmark$qmark("Custom Netty channel options");
        }, InvariantZip$.MODULE$.invariantZipTuple10()).zip((Function0 & Serializable)() -> {
            String x$10 = "sslProvider";
            Function0 & Serializable x$11 = (Function0 & Serializable)() -> MODULE$.sslProvider();
            Option x$12 = zio.config.package$.MODULE$.ConfigDescriptor().nested$default$3("sslProvider");
            return zio.config.package$.MODULE$.ConfigDescriptor().nested("sslProvider", (Function0)x$11, x$12).optional().$qmark$qmark("The SSL provider to be used");
        }, InvariantZip$.MODULE$.invariantZipTuple11()).zip((Function0 & Serializable)() -> {
            String x$13 = "proxy";
            Function0 & Serializable x$14 = (Function0 & Serializable)() -> MODULE$.proxyConfiguration();
            Option x$15 = zio.config.package$.MODULE$.ConfigDescriptor().nested$default$3("proxy");
            return zio.config.package$.MODULE$.ConfigDescriptor().nested("proxy", (Function0)x$14, x$15).optional().$qmark$qmark("Proxy configuration");
        }, InvariantZip$.MODULE$.invariantZipTuple12()).zip((Function0 & Serializable)() -> {
            String x$16 = "http2";
            Function0 & Serializable x$17 = (Function0 & Serializable)() -> MODULE$.http2Configuration();
            Option x$18 = zio.config.package$.MODULE$.ConfigDescriptor().nested$default$3("http2");
            return zio.config.package$.MODULE$.ConfigDescriptor().nested("http2", (Function0)x$17, x$18).optional().$qmark$qmark("HTTP/2 specific options");
        }, InvariantZip$.MODULE$.invariantZipTuple13()).to((TupleConversion)new TupleConversion<NettyClientConfig, Tuple14<Object, Object, Duration, Duration, Duration, Duration, Duration, Duration, Object, Protocol, NettyChannelOptions, Option<SslProvider>, Option<ProxyConfiguration>, Option<Http2Config>>>(){

            public Tuple14<Object, Object, Duration, Duration, Duration, Duration, Duration, Duration, Object, Protocol, NettyChannelOptions, Option<SslProvider>, Option<ProxyConfiguration>, Option<Http2Config>> to(NettyClientConfig a) {
                return new Tuple14((Object)BoxesRunTime.boxToInteger((int)a.maxConcurrency()), (Object)BoxesRunTime.boxToInteger((int)a.maxPendingConnectionAcquires()), (Object)a.readTimeout(), (Object)a.writeTimeout(), (Object)a.connectionTimeout(), (Object)a.connectionAcquisitionTimeout(), (Object)a.connectionTimeToLive(), (Object)a.connectionMaxIdleTime(), (Object)BoxesRunTime.boxToBoolean((boolean)a.useIdleConnectionReaper()), (Object)a.protocol(), (Object)a.channelOptions(), a.sslProvider(), a.proxyConfiguration(), a.http2());
            }

            public NettyClientConfig from(Tuple14<Object, Object, Duration, Duration, Duration, Duration, Duration, Duration, Object, Protocol, NettyChannelOptions, Option<SslProvider>, Option<ProxyConfiguration>, Option<Http2Config>> b) {
                return new NettyClientConfig(BoxesRunTime.unboxToInt((Object)b._1()), BoxesRunTime.unboxToInt((Object)b._2()), (Duration)b._3(), (Duration)b._4(), (Duration)b._5(), (Duration)b._6(), (Duration)b._7(), (Duration)b._8(), BoxesRunTime.unboxToBoolean((Object)b._9()), (Protocol)b._10(), (NettyChannelOptions)b._11(), (Option<SslProvider>)((Option)b._12()), (Option<ProxyConfiguration>)((Option)b._13()), (Option<Http2Config>)((Option)b._14()));
            }
        });
    }

    public ConfigDescriptorModule.ConfigDescriptor<HttpOrHttps> httpOrHttps() {
        return httpOrHttps;
    }

    public ConfigDescriptorModule.ConfigDescriptor<ProxyConfiguration> proxyConfiguration() {
        return proxyConfiguration;
    }

    public ConfigDescriptorModule.ConfigDescriptor<Http2Config> http2Configuration() {
        return http2Configuration;
    }

    public <T, JT> ConfigDescriptorModule.ConfigDescriptor<Option<NettyOptionValue<JT>>> channelOption(ChannelOption<JT> opt2, Function1<JT, T> fromJava, Function1<T, JT> toJava, ConfigDescriptorModule.ConfigDescriptor<T> desc) {
        String x$12 = opt2.name();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> desc;
        Option x$3 = zio.config.package$.MODULE$.ConfigDescriptor().nested$default$3(x$12);
        return zio.config.package$.MODULE$.ConfigDescriptor().nested(x$12, (Function0)x$2, x$3).optional().transform((Function1 & Serializable)x$1 -> x$1.map((Function1 & Serializable)value -> new NettyOptionValue<Object>(opt2, toJava.apply(value))), (Function1 & Serializable)opt -> opt.map((Function1 & Serializable)x$2 -> x$2.value()).map(fromJava));
    }

    public ConfigDescriptorModule.ConfigDescriptor<Option<NettyOptionValue<Boolean>>> boolChannelOption(ChannelOption<Boolean> opt) {
        return this.channelOption(opt, (Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)b), (Function1 & Serializable)b -> BoxesRunTime.unboxToBoolean((Object)b), zio.config.package$.MODULE$.ConfigDescriptor().boolean());
    }

    public ConfigDescriptorModule.ConfigDescriptor<Option<NettyOptionValue<Integer>>> intChannelOption(ChannelOption<Integer> opt) {
        return this.channelOption(opt, (Function1 & Serializable)i -> BoxesRunTime.boxToInteger((int)i), (Function1 & Serializable)i -> BoxesRunTime.unboxToInt((Object)i), zio.config.package$.MODULE$.ConfigDescriptor().int());
    }

    public ConfigDescriptorModule.ConfigDescriptor<Option<NettyOptionValue<Integer>>> durationMsChannelOption(ChannelOption<Integer> opt) {
        return this.channelOption(opt, (Function1 & Serializable)i -> DurationSyntax$.MODULE$.millis$extension(zio.package$.MODULE$.durationInt(i.intValue())), (Function1 & Serializable)d -> (int)d.toMillis(), zio.config.package$.MODULE$.ConfigDescriptor().zioDuration());
    }

    public ConfigDescriptorModule.ConfigDescriptor<NettyChannelOptions> nettyChannelOptions() {
        return nettyChannelOptions;
    }

    public ConfigDescriptorModule.ConfigDescriptor<Protocol> protocol() {
        return protocol;
    }

    public ConfigDescriptorModule.ConfigDescriptor<SslProvider> sslProvider() {
        return sslProvider;
    }

    public ConfigDescriptorModule.ConfigDescriptor<NettyClientConfig> nettyClientConfig() {
        return nettyClientConfig;
    }

    public static final /* synthetic */ boolean $anonfun$nettyChannelOptions$1(ChannelOption key$1, NettyOptionValue opt) {
        ChannelOption channelOption = opt.key();
        ChannelOption channelOption2 = key$1;
        return !(channelOption != null ? !channelOption.equals(channelOption2) : channelOption2 != null);
    }

    private static final Option findOpt$1(NettyChannelOptions options, ChannelOption key) {
        return options.options().find((Function1 & Serializable)opt -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$nettyChannelOptions$1(key, opt)));
    }

    private static final Object globalDefault$1(SdkHttpConfigurationOption key) {
        return SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS.get((AttributeMap.Key)key);
    }

    private package$() {
    }
}

