/*
 * Decompiled with CFR 0.152.
 */
package zio.aws.netty.descriptors;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslProvider;
import java.io.Serializable;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple14;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.utils.AttributeMap;
import zio.Chunk;
import zio.Config;
import zio.Config$;
import zio.DurationSyntax$;
import zio.Zippable$;
import zio.aws.core.httpclient.ChannelOptions;
import zio.aws.core.httpclient.Protocol;
import zio.aws.netty.Http2Config;
import zio.aws.netty.HttpOrHttps;
import zio.aws.netty.HttpOrHttps$Http$;
import zio.aws.netty.HttpOrHttps$Https$;
import zio.aws.netty.NettyChannelOptions;
import zio.aws.netty.NettyClientConfig;
import zio.aws.netty.NettyOptionValue;
import zio.aws.netty.ProxyConfiguration;

public final class package$ {
    public static package$ MODULE$;
    private final Config<HttpOrHttps> httpOrHttps;
    private final Config<ProxyConfiguration> proxyConfiguration;
    private final Config<Http2Config> http2Configuration;
    private final Config<NettyChannelOptions> nettyChannelOptions;
    private final Config<Protocol> protocol;
    private final Config<SslProvider> sslProvider;
    private final Config<NettyClientConfig> nettyClientConfig;

    static {
        new package$();
    }

    public Config<HttpOrHttps> httpOrHttps() {
        return this.httpOrHttps;
    }

    public Config<ProxyConfiguration> proxyConfiguration() {
        return this.proxyConfiguration;
    }

    public Config<Http2Config> http2Configuration() {
        return this.http2Configuration;
    }

    public <T, JT> Config<Option<NettyOptionValue<JT>>> channelOption(ChannelOption<JT> opt, Function1<T, JT> toJava, Config<T> desc) {
        return desc.nested((Function0 & Serializable & scala.Serializable)() -> opt.name()).optional().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.map((Function1 & Serializable & scala.Serializable)value -> new NettyOptionValue<Object>(opt, toJava.apply(value))));
    }

    public Config<Option<NettyOptionValue<Boolean>>> boolChannelOption(ChannelOption<Boolean> opt) {
        return this.channelOption(opt, (Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.unboxToBoolean((Object)b), Config$.MODULE$.boolean());
    }

    public Config<Option<NettyOptionValue<Integer>>> intChannelOption(ChannelOption<Integer> opt) {
        return this.channelOption(opt, (Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToInt((Object)i), Config$.MODULE$.int());
    }

    public Config<Option<NettyOptionValue<Integer>>> durationMsChannelOption(ChannelOption<Integer> opt) {
        return this.channelOption(opt, (Function1 & Serializable & scala.Serializable)d -> (int)d.toMillis(), Config$.MODULE$.duration());
    }

    public Config<NettyChannelOptions> nettyChannelOptions() {
        return this.nettyChannelOptions;
    }

    public Config<Protocol> protocol() {
        return this.protocol;
    }

    public Config<SslProvider> sslProvider() {
        return this.sslProvider;
    }

    public Config<NettyClientConfig> nettyClientConfig() {
        return this.nettyClientConfig;
    }

    private static final Object globalDefault$1(SdkHttpConfigurationOption key) {
        return SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS.get((AttributeMap.Key)key);
    }

    private package$() {
        MODULE$ = this;
        this.httpOrHttps = Config$.MODULE$.string().mapOrFail((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            if ("http".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)HttpOrHttps$Http$.MODULE$);
            }
            if ("https".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)HttpOrHttps$Https$.MODULE$);
            }
            if (string != null) {
                String string2 = string;
                String x$1 = new StringBuilder(37).append("Invalid value ").append(string2).append(". Use 'http' or 'https'").toString();
                Chunk x$2 = Config.Error$.InvalidData$.MODULE$.apply$default$1();
                return scala.package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(x$2, x$1));
            }
            throw new MatchError((Object)string);
        });
        this.proxyConfiguration = this.httpOrHttps().nested((Function0 & Serializable & scala.Serializable)() -> "scheme").withDefault((Function0 & Serializable & scala.Serializable)() -> HttpOrHttps$Http$.MODULE$).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "The proxy scheme").zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.string("host").$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Hostname of the proxy"), Zippable$.MODULE$.Zippable2()).zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.int("port").$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Port of the proxy"), Zippable$.MODULE$.Zippable3()).zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.setOf("nonProxyHosts", Config$.MODULE$.string()).withDefault((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty()).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Hosts that should not be proxied"), Zippable$.MODULE$.Zippable4()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple4 tuple4 = x0$2;
            if (tuple4 != null) {
                HttpOrHttps scheme = (HttpOrHttps)tuple4._1();
                String host = (String)tuple4._2();
                int port = BoxesRunTime.unboxToInt((Object)tuple4._3());
                Set nonProxyHosts = (Set)tuple4._4();
                return new ProxyConfiguration(scheme, host, port, (Set<String>)nonProxyHosts);
            }
            throw new MatchError((Object)tuple4);
        });
        this.http2Configuration = Config$.MODULE$.int("maxStreams").$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Max number of concurrent streams per connection").zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.int("initialWindowSize").$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Initial window size of a stream"), Zippable$.MODULE$.Zippable2()).zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.duration("healthCheckPingPeriod").withDefault((Function0 & Serializable & scala.Serializable)() -> DurationSyntax$.MODULE$.seconds$extension(zio.package$.MODULE$.durationInt(5))).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "The period that the Netty client will send PING frames to the remote endpoint"), Zippable$.MODULE$.Zippable3()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple3 tuple3 = x0$3;
            if (tuple3 != null) {
                int maxStreams = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int initialWindowSize = BoxesRunTime.unboxToInt((Object)tuple3._2());
                Duration healthCheckPingPeriod = (Duration)tuple3._3();
                return new Http2Config(maxStreams, initialWindowSize, healthCheckPingPeriod);
            }
            throw new MatchError((Object)tuple3);
        });
        Config socketChannelOptions = zio.aws.core.httpclient.descriptors.package$.MODULE$.channelOptions();
        Config channelOptions = this.durationMsChannelOption((ChannelOption<Integer>)ChannelOption.CONNECT_TIMEOUT_MILLIS).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Connect timeout").zip((Function0 & Serializable & scala.Serializable)() -> MODULE$.intChannelOption((ChannelOption<Integer>)ChannelOption.WRITE_SPIN_COUNT).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Write spin count"), Zippable$.MODULE$.Zippable2()).zip((Function0 & Serializable & scala.Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.ALLOW_HALF_CLOSURE).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Allow half closure"), Zippable$.MODULE$.Zippable3()).zip((Function0 & Serializable & scala.Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.AUTO_READ).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Auto read"), Zippable$.MODULE$.Zippable4()).zip((Function0 & Serializable & scala.Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.AUTO_CLOSE).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Auto close"), Zippable$.MODULE$.Zippable5()).zip((Function0 & Serializable & scala.Serializable)() -> MODULE$.boolChannelOption((ChannelOption<Boolean>)ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Single event executor per group"), Zippable$.MODULE$.Zippable6()).map((Function1 & Serializable & scala.Serializable)tuple -> new NettyChannelOptions(tuple.productIterator().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Some some;
                Object opt;
                A1 A1 = x1;
                if (A1 instanceof Some && (opt = (some = (Some)A1).value()) instanceof NettyOptionValue) {
                    NettyOptionValue nettyOptionValue = (NettyOptionValue)opt;
                    return (B1)nettyOptionValue;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Some some;
                Object opt;
                Object object = x1;
                return object instanceof Some && (opt = (some = (Some)object).value()) instanceof NettyOptionValue;
            }
        }).toVector()));
        this.nettyChannelOptions = socketChannelOptions.zip((Function0 & Serializable & scala.Serializable)() -> channelOptions, Zippable$.MODULE$.Zippable2()).mapOrFail((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                ChannelOptions opts1 = (ChannelOptions)tuple2._1();
                NettyChannelOptions opts2 = (NettyChannelOptions)tuple2._2();
                return scala.package$.MODULE$.Right().apply((Object)opts2.withSocketOptions(opts1));
            }
            throw new MatchError((Object)tuple2);
        });
        this.protocol = Config$.MODULE$.string().mapOrFail((Function1 & Serializable & scala.Serializable)x0$5 -> {
            String string = x0$5;
            if ("HTTP/1.1".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)Protocol.Http11$.MODULE$);
            }
            if ("HTTP/2".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)Protocol.Http2$.MODULE$);
            }
            if ("Dual".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)Protocol.Dual$.MODULE$);
            }
            if (string != null) {
                String string2 = string;
                String x$3 = new StringBuilder(58).append("Invalid protocol: '").append(string2).append("'. Use 'HTTP/1.1' or 'HTTP/2' or 'Dual'").toString();
                Chunk x$4 = Config.Error$.InvalidData$.MODULE$.apply$default$1();
                return scala.package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(x$4, x$3));
            }
            throw new MatchError((Object)string);
        });
        this.sslProvider = Config$.MODULE$.string().mapOrFail((Function1 & Serializable & scala.Serializable)x0$6 -> {
            String string = x0$6;
            if ("JDK".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)SslProvider.JDK);
            }
            if ("OPENSSL".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)SslProvider.OPENSSL);
            }
            if ("OPENSSL_REFCNT".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)SslProvider.OPENSSL_REFCNT);
            }
            if (string != null) {
                String string2 = string;
                String x$5 = new StringBuilder(66).append("Invalid SSL provider: '").append(string2).append("'. Use 'JDK', 'OPENSSL' or 'OPENSSL_REFCNT'").toString();
                Chunk x$6 = Config.Error$.InvalidData$.MODULE$.apply$default$1();
                return scala.package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(x$6, x$5));
            }
            throw new MatchError((Object)string);
        });
        this.nettyClientConfig = Config$.MODULE$.int("maxConcurrency").withDefault((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int((Integer)package$.globalDefault$1(SdkHttpConfigurationOption.MAX_CONNECTIONS))).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Maximum number of allowed concurrent requests").zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.int("maxPendingConnectionAcquires").withDefault((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int((Integer)package$.globalDefault$1(SdkHttpConfigurationOption.MAX_PENDING_CONNECTION_ACQUIRES))).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "The maximum number of pending acquires allowed"), Zippable$.MODULE$.Zippable2()).zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.duration("readTimeout").withDefault((Function0 & Serializable & scala.Serializable)() -> (Duration)package$.globalDefault$1(SdkHttpConfigurationOption.READ_TIMEOUT)).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "The amount of time to wait for a read on a socket"), Zippable$.MODULE$.Zippable3()).zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.duration("writeTimeout").withDefault((Function0 & Serializable & scala.Serializable)() -> (Duration)package$.globalDefault$1(SdkHttpConfigurationOption.WRITE_TIMEOUT)).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "The amount of time to wait for a write on a socket"), Zippable$.MODULE$.Zippable4()).zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.duration("connectionTimeout").withDefault((Function0 & Serializable & scala.Serializable)() -> (Duration)package$.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "The amount of time to wait when initially establishing a connection before giving up"), Zippable$.MODULE$.Zippable5()).zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.duration("connectionAcquisitionTimeout").withDefault((Function0 & Serializable & scala.Serializable)() -> (Duration)package$.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT)).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "The amount of time to wait when acquiring a connection from the pool before giving up"), Zippable$.MODULE$.Zippable6()).zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.duration("connectionTimeToLive").withDefault((Function0 & Serializable & scala.Serializable)() -> (Duration)package$.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE)).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "The maximum amount of time that a connection should be allowed to remain open, regardless of usage frequency"), Zippable$.MODULE$.Zippable7()).zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.duration("connectionMaxIdleTime").withDefault((Function0 & Serializable & scala.Serializable)() -> DurationSyntax$.MODULE$.seconds$extension(zio.package$.MODULE$.durationInt(5))).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Maximum amount of time that a connection should be allowed to remain open while idle"), Zippable$.MODULE$.Zippable8()).zip((Function0 & Serializable & scala.Serializable)() -> Config$.MODULE$.boolean("useIdleConnectionReaper").withDefault((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)package$.globalDefault$1(SdkHttpConfigurationOption.REAP_IDLE_CONNECTIONS)).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "If true, the idle connections in the pool should be closed"), Zippable$.MODULE$.Zippable9()).zip((Function0 & Serializable & scala.Serializable)() -> MODULE$.protocol().nested((Function0 & Serializable & scala.Serializable)() -> "protocol").withDefault((Function0 & Serializable & scala.Serializable)() -> Protocol.Dual$.MODULE$).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "HTTP/1.1 or HTTP/2 or Dual"), Zippable$.MODULE$.Zippable10()).zip((Function0 & Serializable & scala.Serializable)() -> MODULE$.nettyChannelOptions().nested((Function0 & Serializable & scala.Serializable)() -> "channelOptions").withDefault((Function0 & Serializable & scala.Serializable)() -> new NettyChannelOptions(scala.package$.MODULE$.Vector().empty())).$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Custom Netty channel options"), Zippable$.MODULE$.Zippable11()).zip((Function0 & Serializable & scala.Serializable)() -> MODULE$.sslProvider().nested((Function0 & Serializable & scala.Serializable)() -> "sslProvider").optional().$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "The SSL provider to be used"), Zippable$.MODULE$.Zippable12()).zip((Function0 & Serializable & scala.Serializable)() -> MODULE$.proxyConfiguration().nested((Function0 & Serializable & scala.Serializable)() -> "proxy").optional().$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "Proxy configuration"), Zippable$.MODULE$.Zippable13()).zip((Function0 & Serializable & scala.Serializable)() -> MODULE$.http2Configuration().nested((Function0 & Serializable & scala.Serializable)() -> "http2").optional().$qmark$qmark((Function0 & Serializable & scala.Serializable)() -> "HTTP/2 specific options"), Zippable$.MODULE$.Zippable14()).map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple14 tuple14 = x0$7;
            if (tuple14 != null) {
                int maxConcurrency = BoxesRunTime.unboxToInt((Object)tuple14._1());
                int maxPendingConnectionAcquires = BoxesRunTime.unboxToInt((Object)tuple14._2());
                Duration readTimeout = (Duration)tuple14._3();
                Duration writeTimeout = (Duration)tuple14._4();
                Duration connectionTimeout = (Duration)tuple14._5();
                Duration connectionAcquisitionTimeout = (Duration)tuple14._6();
                Duration connectionTimeToLive = (Duration)tuple14._7();
                Duration connectionMaxIdleTime = (Duration)tuple14._8();
                boolean useIdleConnectionReaper = BoxesRunTime.unboxToBoolean((Object)tuple14._9());
                Protocol protocol = (Protocol)tuple14._10();
                NettyChannelOptions channelOptions = (NettyChannelOptions)tuple14._11();
                Option sslProvider = (Option)tuple14._12();
                Option proxyConfiguration = (Option)tuple14._13();
                Option http2Configuration = (Option)tuple14._14();
                return new NettyClientConfig(maxConcurrency, maxPendingConnectionAcquires, readTimeout, writeTimeout, connectionTimeout, connectionAcquisitionTimeout, connectionTimeToLive, connectionMaxIdleTime, useIdleConnectionReaper, protocol, channelOptions, (Option<SslProvider>)sslProvider, (Option<ProxyConfiguration>)proxyConfiguration, (Option<Http2Config>)http2Configuration);
            }
            throw new MatchError((Object)tuple14);
        });
    }
}

