package zio.aws.migrationhubrefactorspaces.model
import scala.jdk.CollectionConverters.*
sealed trait NetworkFabricType {
  def unwrap: software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType
}
object NetworkFabricType {
  def wrap(
      value: software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType
  ): zio.aws.migrationhubrefactorspaces.model.NetworkFabricType = value match {
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType.TRANSIT_GATEWAY =>
      val r = TRANSIT_GATEWAY
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhubrefactorspaces.model.NetworkFabricType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRANSIT_GATEWAY
      extends zio.aws.migrationhubrefactorspaces.model.NetworkFabricType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType.TRANSIT_GATEWAY
  }
  case object NONE
      extends zio.aws.migrationhubrefactorspaces.model.NetworkFabricType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.NetworkFabricType.NONE
  }
}
