package zio.aws.migrationhubrefactorspaces.model
import zio.prelude.data.Optional
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  NextToken,
  MaxResults,
  EnvironmentId,
  ApplicationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRoutesRequest(
    applicationIdentifier: ApplicationId,
    environmentIdentifier: EnvironmentId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesRequest = {
    import ListRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesRequest
      .builder()
      .applicationIdentifier(
        ApplicationId.unwrap(applicationIdentifier): java.lang.String
      )
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest
      .wrap(buildAwsValue())
}
object ListRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest =
      zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest(
        applicationIdentifier,
        environmentIdentifier,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def applicationIdentifier: ApplicationId
    def environmentIdentifier: EnvironmentId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getApplicationIdentifier: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest.ReadOnly {
    override val applicationIdentifier: ApplicationId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ApplicationId(impl.applicationIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesRequest
  ): zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest.ReadOnly =
    new Wrapper(impl)
}
