package zio.aws.migrationhubrefactorspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  VpcId,
  ServiceId,
  TagMapKeyString,
  AccountId,
  Timestamp,
  EnvironmentId,
  Description,
  ResourceArn,
  TagMapValueString,
  ServiceName,
  ApplicationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetServiceResponse(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    arn: Optional[ResourceArn] = Optional.Absent,
    createdByAccountId: Optional[AccountId] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    endpointType: Optional[
      zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType
    ] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    error: Optional[zio.aws.migrationhubrefactorspaces.model.ErrorResponse] =
      Optional.Absent,
    lambdaEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig
    ] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    name: Optional[ServiceName] = Optional.Absent,
    ownerAccountId: Optional[AccountId] = Optional.Absent,
    serviceId: Optional[ServiceId] = Optional.Absent,
    state: Optional[zio.aws.migrationhubrefactorspaces.model.ServiceState] =
      Optional.Absent,
    tags: Optional[Map[TagMapKeyString, TagMapValueString]] = Optional.Absent,
    urlEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig
    ] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetServiceResponse = {
    import GetServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetServiceResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdByAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.createdByAccountId)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(lambdaEndpoint.map(value => value.buildAwsValue()))(
        _.lambdaEndpoint
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString.unwrap(
                key
              ): java.lang.String) -> (TagMapValueString.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(urlEndpoint.map(value => value.buildAwsValue()))(
        _.urlEndpoint
      )
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.GetServiceResponse
      .wrap(buildAwsValue())
}
object GetServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.GetServiceResponse =
      zio.aws.migrationhubrefactorspaces.model.GetServiceResponse(
        applicationId.map(value => value),
        arn.map(value => value),
        createdByAccountId.map(value => value),
        createdTime.map(value => value),
        description.map(value => value),
        endpointType.map(value => value),
        environmentId.map(value => value),
        error.map(value => value.asEditable),
        lambdaEndpoint.map(value => value.asEditable),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        ownerAccountId.map(value => value),
        serviceId.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        urlEndpoint.map(value => value.asEditable),
        vpcId.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def arn: Optional[ResourceArn]
    def createdByAccountId: Optional[AccountId]
    def createdTime: Optional[Timestamp]
    def description: Optional[Description]
    def endpointType
        : Optional[zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType]
    def environmentId: Optional[EnvironmentId]
    def error: Optional[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ]
    def lambdaEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig.ReadOnly
    ]
    def lastUpdatedTime: Optional[Timestamp]
    def name: Optional[ServiceName]
    def ownerAccountId: Optional[AccountId]
    def serviceId: Optional[ServiceId]
    def state: Optional[zio.aws.migrationhubrefactorspaces.model.ServiceState]
    def tags: Optional[Map[TagMapKeyString, TagMapValueString]]
    def urlEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.ReadOnly
    ]
    def vpcId: Optional[VpcId]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdByAccountId", createdByAccountId)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType
    ] = AwsError.unwrapOptionField("endpointType", endpointType)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getLambdaEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaEndpoint", lambdaEndpoint)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("name", name)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ServiceState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUrlEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("urlEndpoint", urlEndpoint)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetServiceResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val createdByAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.createdByAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Description(value)
      )
    override val endpointType: Optional[
      zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointType())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType.wrap(value)
      )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val error: Optional[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ErrorResponse.wrap(value)
      )
    override val lambdaEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaEndpoint())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig
          .wrap(value)
      )
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val name: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceName(value)
      )
    override val ownerAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val serviceId: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId(value)
      )
    override val state
        : Optional[zio.aws.migrationhubrefactorspaces.model.ServiceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.ServiceState.wrap(value)
        )
    override val tags: Optional[Map[TagMapKeyString, TagMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapKeyString(
                  key
                ) -> zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapValueString(value)
            })
            .toMap
        )
    override val urlEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.urlEndpoint())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.wrap(value)
      )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.VpcId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetServiceResponse
  ): zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly =
    new Wrapper(impl)
}
