package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.Uri
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UrlEndpointInput(
    healthUrl: Optional[Uri] = Optional.Absent,
    url: Uri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointInput = {
    import UrlEndpointInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointInput
      .builder()
      .optionallyWith(
        healthUrl.map(value => Uri.unwrap(value): java.lang.String)
      )(_.healthUrl)
      .url(Uri.unwrap(url): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.UrlEndpointInput.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.UrlEndpointInput
      .wrap(buildAwsValue())
}
object UrlEndpointInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.UrlEndpointInput =
      zio.aws.migrationhubrefactorspaces.model
        .UrlEndpointInput(healthUrl.map(value => value), url)
    def healthUrl: Optional[Uri]
    def url: Uri
    def getHealthUrl: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("healthUrl", healthUrl)
    def getUrl: ZIO[Any, Nothing, Uri] = ZIO.succeed(url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointInput
  ) extends zio.aws.migrationhubrefactorspaces.model.UrlEndpointInput.ReadOnly {
    override val healthUrl: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.healthUrl())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Uri(value)
      )
    override val url: Uri =
      zio.aws.migrationhubrefactorspaces.model.primitives.Uri(impl.url())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointInput
  ): zio.aws.migrationhubrefactorspaces.model.UrlEndpointInput.ReadOnly =
    new Wrapper(impl)
}
