package zio.aws.migrationhubrefactorspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ServiceId,
  Timestamp,
  EnvironmentId,
  ResourceArn,
  ServiceName,
  ApplicationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeleteServiceResponse(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    arn: Optional[ResourceArn] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    name: Optional[ServiceName] = Optional.Absent,
    serviceId: Optional[ServiceId] = Optional.Absent,
    state: Optional[zio.aws.migrationhubrefactorspaces.model.ServiceState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceResponse = {
    import DeleteServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse
      .wrap(buildAwsValue())
}
object DeleteServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse =
      zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse(
        applicationId.map(value => value),
        arn.map(value => value),
        environmentId.map(value => value),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        serviceId.map(value => value),
        state.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def arn: Optional[ResourceArn]
    def environmentId: Optional[EnvironmentId]
    def lastUpdatedTime: Optional[Timestamp]
    def name: Optional[ServiceName]
    def serviceId: Optional[ServiceId]
    def state: Optional[zio.aws.migrationhubrefactorspaces.model.ServiceState]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("name", name)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ServiceState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val name: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceName(value)
      )
    override val serviceId: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId(value)
      )
    override val state
        : Optional[zio.aws.migrationhubrefactorspaces.model.ServiceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.ServiceState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceResponse
  ): zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly =
    new Wrapper(impl)
}
