package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  RouteId,
  EnvironmentId,
  ApplicationId
}
import scala.jdk.CollectionConverters.*
final case class UpdateRouteRequest(
    activationState: zio.aws.migrationhubrefactorspaces.model.RouteActivationState,
    applicationIdentifier: ApplicationId,
    environmentIdentifier: EnvironmentId,
    routeIdentifier: RouteId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.UpdateRouteRequest = {
    import UpdateRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UpdateRouteRequest
      .builder()
      .activationState(activationState.unwrap)
      .applicationIdentifier(
        ApplicationId.unwrap(applicationIdentifier): java.lang.String
      )
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .routeIdentifier(RouteId.unwrap(routeIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.UpdateRouteRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.UpdateRouteRequest
      .wrap(buildAwsValue())
}
object UpdateRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UpdateRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.UpdateRouteRequest =
      zio.aws.migrationhubrefactorspaces.model.UpdateRouteRequest(
        activationState,
        applicationIdentifier,
        environmentIdentifier,
        routeIdentifier
      )
    def activationState
        : zio.aws.migrationhubrefactorspaces.model.RouteActivationState
    def applicationIdentifier: ApplicationId
    def environmentIdentifier: EnvironmentId
    def routeIdentifier: RouteId
    def getActivationState: ZIO[
      Any,
      Nothing,
      zio.aws.migrationhubrefactorspaces.model.RouteActivationState
    ] = ZIO.succeed(activationState)
    def getApplicationIdentifier: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getRouteIdentifier: ZIO[Any, Nothing, RouteId] =
      ZIO.succeed(routeIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UpdateRouteRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.UpdateRouteRequest.ReadOnly {
    override val activationState
        : zio.aws.migrationhubrefactorspaces.model.RouteActivationState =
      zio.aws.migrationhubrefactorspaces.model.RouteActivationState
        .wrap(impl.activationState())
    override val applicationIdentifier: ApplicationId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ApplicationId(impl.applicationIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val routeIdentifier: RouteId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .RouteId(impl.routeIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UpdateRouteRequest
  ): zio.aws.migrationhubrefactorspaces.model.UpdateRouteRequest.ReadOnly =
    new Wrapper(impl)
}
