package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultRouteInput(
    activationState: Optional[
      zio.aws.migrationhubrefactorspaces.model.RouteActivationState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.DefaultRouteInput = {
    import DefaultRouteInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DefaultRouteInput
      .builder()
      .optionallyWith(activationState.map(value => value.unwrap))(
        _.activationState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.DefaultRouteInput.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.DefaultRouteInput
      .wrap(buildAwsValue())
}
object DefaultRouteInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DefaultRouteInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.DefaultRouteInput =
      zio.aws.migrationhubrefactorspaces.model
        .DefaultRouteInput(activationState.map(value => value))
    def activationState: Optional[
      zio.aws.migrationhubrefactorspaces.model.RouteActivationState
    ]
    def getActivationState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteActivationState
    ] = AwsError.unwrapOptionField("activationState", activationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DefaultRouteInput
  ) extends zio.aws.migrationhubrefactorspaces.model.DefaultRouteInput.ReadOnly {
    override val activationState: Optional[
      zio.aws.migrationhubrefactorspaces.model.RouteActivationState
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activationState())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.RouteActivationState
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DefaultRouteInput
  ): zio.aws.migrationhubrefactorspaces.model.DefaultRouteInput.ReadOnly =
    new Wrapper(impl)
}
