package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId
import scala.jdk.CollectionConverters.*
final case class DeleteEnvironmentRequest(
    environmentIdentifier: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteEnvironmentRequest = {
    import DeleteEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteEnvironmentRequest
      .builder()
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentRequest
      .wrap(buildAwsValue())
}
object DeleteEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentRequest =
      zio.aws.migrationhubrefactorspaces.model
        .DeleteEnvironmentRequest(environmentIdentifier)
    def environmentIdentifier: EnvironmentId
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteEnvironmentRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentRequest.ReadOnly {
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteEnvironmentRequest
  ): zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
