package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ServiceId,
  EnvironmentId,
  ApplicationId
}
import scala.jdk.CollectionConverters.*
final case class DeleteServiceRequest(
    applicationIdentifier: ApplicationId,
    environmentIdentifier: EnvironmentId,
    serviceIdentifier: ServiceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceRequest = {
    import DeleteServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceRequest
      .builder()
      .applicationIdentifier(
        ApplicationId.unwrap(applicationIdentifier): java.lang.String
      )
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .serviceIdentifier(ServiceId.unwrap(serviceIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.DeleteServiceRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.DeleteServiceRequest
      .wrap(buildAwsValue())
}
object DeleteServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.DeleteServiceRequest =
      zio.aws.migrationhubrefactorspaces.model.DeleteServiceRequest(
        applicationIdentifier,
        environmentIdentifier,
        serviceIdentifier
      )
    def applicationIdentifier: ApplicationId
    def environmentIdentifier: EnvironmentId
    def serviceIdentifier: ServiceId
    def getApplicationIdentifier: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceId] =
      ZIO.succeed(serviceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.DeleteServiceRequest.ReadOnly {
    override val applicationIdentifier: ApplicationId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ApplicationId(impl.applicationIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val serviceIdentifier: ServiceId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ServiceId(impl.serviceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceRequest
  ): zio.aws.migrationhubrefactorspaces.model.DeleteServiceRequest.ReadOnly =
    new Wrapper(impl)
}
