package zio.aws.migrationhubrefactorspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ServiceId,
  Timestamp,
  ResourceArn,
  RouteId,
  ApplicationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateRouteResponse(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    arn: Optional[ResourceArn] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    routeId: Optional[RouteId] = Optional.Absent,
    serviceId: Optional[ServiceId] = Optional.Absent,
    state: Optional[zio.aws.migrationhubrefactorspaces.model.RouteState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.UpdateRouteResponse = {
    import UpdateRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UpdateRouteResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        routeId.map(value => RouteId.unwrap(value): java.lang.String)
      )(_.routeId)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.UpdateRouteResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.UpdateRouteResponse
      .wrap(buildAwsValue())
}
object UpdateRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UpdateRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.UpdateRouteResponse =
      zio.aws.migrationhubrefactorspaces.model.UpdateRouteResponse(
        applicationId.map(value => value),
        arn.map(value => value),
        lastUpdatedTime.map(value => value),
        routeId.map(value => value),
        serviceId.map(value => value),
        state.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def arn: Optional[ResourceArn]
    def lastUpdatedTime: Optional[Timestamp]
    def routeId: Optional[RouteId]
    def serviceId: Optional[ServiceId]
    def state: Optional[zio.aws.migrationhubrefactorspaces.model.RouteState]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getRouteId: ZIO[Any, AwsError, RouteId] =
      AwsError.unwrapOptionField("routeId", routeId)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UpdateRouteResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.UpdateRouteResponse.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val routeId: Optional[RouteId] = zio.aws.core.internal
      .optionalFromNullable(impl.routeId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.RouteId(value)
      )
    override val serviceId: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId(value)
      )
    override val state
        : Optional[zio.aws.migrationhubrefactorspaces.model.RouteState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.RouteState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UpdateRouteResponse
  ): zio.aws.migrationhubrefactorspaces.model.UpdateRouteResponse.ReadOnly =
    new Wrapper(impl)
}
