package zio.aws.migrationhubrefactorspaces.model
import scala.jdk.CollectionConverters.*
sealed trait ProxyType {
  def unwrap: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ProxyType
}
object ProxyType {
  def wrap(
      value: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ProxyType
  ): zio.aws.migrationhubrefactorspaces.model.ProxyType = value match {
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ProxyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ProxyType.API_GATEWAY =>
      val r = API_GATEWAY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhubrefactorspaces.model.ProxyType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ProxyType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ProxyType.UNKNOWN_TO_SDK_VERSION
  }
  case object API_GATEWAY
      extends zio.aws.migrationhubrefactorspaces.model.ProxyType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ProxyType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ProxyType.API_GATEWAY
  }
}
