package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  EnvironmentId,
  ApplicationId
}
import scala.jdk.CollectionConverters.*
final case class GetApplicationRequest(
    applicationIdentifier: ApplicationId,
    environmentIdentifier: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetApplicationRequest = {
    import GetApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetApplicationRequest
      .builder()
      .applicationIdentifier(
        ApplicationId.unwrap(applicationIdentifier): java.lang.String
      )
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.GetApplicationRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.GetApplicationRequest
      .wrap(buildAwsValue())
}
object GetApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.GetApplicationRequest =
      zio.aws.migrationhubrefactorspaces.model
        .GetApplicationRequest(applicationIdentifier, environmentIdentifier)
    def applicationIdentifier: ApplicationId
    def environmentIdentifier: EnvironmentId
    def getApplicationIdentifier: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetApplicationRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.GetApplicationRequest.ReadOnly {
    override val applicationIdentifier: ApplicationId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ApplicationId(impl.applicationIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetApplicationRequest
  ): zio.aws.migrationhubrefactorspaces.model.GetApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
