package zio.aws.migrationhubrefactorspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  TagMapKeyString,
  AccountId,
  Timestamp,
  EnvironmentName,
  TransitGatewayId,
  EnvironmentId,
  Description,
  ResourceArn,
  TagMapValueString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EnvironmentSummary(
    arn: Optional[ResourceArn] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    error: Optional[zio.aws.migrationhubrefactorspaces.model.ErrorResponse] =
      Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    name: Optional[EnvironmentName] = Optional.Absent,
    networkFabricType: Optional[
      zio.aws.migrationhubrefactorspaces.model.NetworkFabricType
    ] = Optional.Absent,
    ownerAccountId: Optional[AccountId] = Optional.Absent,
    state: Optional[zio.aws.migrationhubrefactorspaces.model.EnvironmentState] =
      Optional.Absent,
    tags: Optional[Map[TagMapKeyString, TagMapValueString]] = Optional.Absent,
    transitGatewayId: Optional[TransitGatewayId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentSummary = {
    import EnvironmentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentSummary
      .builder()
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value => EnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(networkFabricType.map(value => value.unwrap))(
        _.networkFabricType
      )
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary
      .wrap(buildAwsValue())
}
object EnvironmentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary =
      zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary(
        arn.map(value => value),
        createdTime.map(value => value),
        description.map(value => value),
        environmentId.map(value => value),
        error.map(value => value.asEditable),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        networkFabricType.map(value => value),
        ownerAccountId.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        transitGatewayId.map(value => value)
      )
    def arn: Optional[ResourceArn]
    def createdTime: Optional[Timestamp]
    def description: Optional[Description]
    def environmentId: Optional[EnvironmentId]
    def error: Optional[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ]
    def lastUpdatedTime: Optional[Timestamp]
    def name: Optional[EnvironmentName]
    def networkFabricType
        : Optional[zio.aws.migrationhubrefactorspaces.model.NetworkFabricType]
    def ownerAccountId: Optional[AccountId]
    def state
        : Optional[zio.aws.migrationhubrefactorspaces.model.EnvironmentState]
    def tags: Optional[Map[TagMapKeyString, TagMapValueString]]
    def transitGatewayId: Optional[TransitGatewayId]
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getNetworkFabricType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.NetworkFabricType
    ] = AwsError.unwrapOptionField("networkFabricType", networkFabricType)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.EnvironmentState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentSummary
  ) extends zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly {
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Description(value)
      )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val error: Optional[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ErrorResponse.wrap(value)
      )
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val name: Optional[EnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives
          .EnvironmentName(value)
      )
    override val networkFabricType
        : Optional[zio.aws.migrationhubrefactorspaces.model.NetworkFabricType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkFabricType())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.NetworkFabricType.wrap(value)
        )
    override val ownerAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val state
        : Optional[zio.aws.migrationhubrefactorspaces.model.EnvironmentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.EnvironmentState.wrap(value)
        )
    override val tags: Optional[Map[TagMapKeyString, TagMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapKeyString(
                  key
                ) -> zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapValueString(value)
            })
            .toMap
        )
    override val transitGatewayId: Optional[TransitGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayId())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.primitives
            .TransitGatewayId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentSummary
  ): zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly =
    new Wrapper(impl)
}
